/**
 * Mission Stickers API
 * This document describes LINE Mission Stickers API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import HTTPFetchClient, { mergeHeaders, } from "../../http-fetch.js";
export class ShopClient {
    httpClient;
    constructor(config) {
        const baseURL = config.baseURL || "https://api.line.me";
        const defaultHeaders = mergeHeaders(config.defaultHeaders, {
            Authorization: "Bearer " + config.channelAccessToken,
        });
        this.httpClient = new HTTPFetchClient({
            defaultHeaders: defaultHeaders,
            baseURL: baseURL,
        });
    }
    /**
     * Sends a mission sticker.
     * @param missionStickerRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#send-mission-stickers-v3"> Documentation</a>
     */
    async missionStickerV3(missionStickerRequest) {
        return (await this.missionStickerV3WithHttpInfo(missionStickerRequest))
            .body;
    }
    /**
     * Sends a mission sticker..
     * This method includes HttpInfo object to return additional information.
     * @param missionStickerRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#send-mission-stickers-v3"> Documentation</a>
     */
    async missionStickerV3WithHttpInfo(missionStickerRequest) {
        const params = missionStickerRequest;
        const res = await this.httpClient.post("/shop/v3/mission", params);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
}
//# sourceMappingURL=shopClient.js.map