/**
 * Webhook Type Definition
 * Webhook event definition of the LINE Messaging API
 *
 * The version of the OpenAPI document: 1.0.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { MessageContentBase } from "./models.js";
export type StickerMessageContent = MessageContentBase & {
    type: "sticker";
    /**
     * Package ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#wh-sticker">packageId Documentation</a>
     */
    packageId: string;
    /**
     * Sticker ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#wh-sticker">stickerId Documentation</a>
     */
    stickerId: string;
    /**
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#wh-sticker">stickerResourceType Documentation</a>
     */
    stickerResourceType: StickerMessageContent.StickerResourceTypeEnum;
    /**
     * Array of up to 15 keywords describing the sticker. If a sticker has 16 or more keywords, a random selection of 15 keywords will be returned. The keyword selection is random for each event, so different keywords may be returned for the same sticker.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#wh-sticker">keywords Documentation</a>
     */
    keywords?: Array<string>;
    /**
     * Any text entered by the user. This property is only included for message stickers. Max character limit: 100
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#wh-sticker">text Documentation</a>
     */
    text?: string;
    /**
     * Quote token to quote this message.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#wh-sticker">quoteToken Documentation</a>
     */
    quoteToken: string;
    /**
     * Message ID of a quoted message. Only included when the received message quotes a past message.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#wh-sticker">quotedMessageId Documentation</a>
     */
    quotedMessageId?: string;
    /**
     * Token used to mark the message as read.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#wh-sticker">markAsReadToken Documentation</a>
     */
    markAsReadToken?: string;
};
export declare namespace StickerMessageContent {
    type StickerResourceTypeEnum = "STATIC" | "ANIMATION" | "SOUND" | "ANIMATION_SOUND" | "POPUP" | "POPUP_SOUND" | "CUSTOM" | "MESSAGE" | "NAME_TEXT" | "PER_STICKER_TEXT";
}
//# sourceMappingURL=stickerMessageContent.d.ts.map