/**
 * LIFF server API
 * LIFF Server API.
 *
 * The version of the OpenAPI document: 1.0.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/* tslint:disable:no-unused-locals */
import { AddLiffAppRequest } from "../model/addLiffAppRequest.js";
import { AddLiffAppResponse } from "../model/addLiffAppResponse.js";
import { GetAllLiffAppsResponse } from "../model/getAllLiffAppsResponse.js";
import { UpdateLiffAppRequest } from "../model/updateLiffAppRequest.js";

import * as Types from "../../types.js";
import { ensureJSON } from "../../utils.js";
import { Readable } from "node:stream";

import HTTPFetchClient, {
  convertResponseToReadable,
  mergeHeaders,
} from "../../http-fetch.js";

// ===============================================
// This file is autogenerated - Please do not edit
// ===============================================

interface httpClientConfig {
  baseURL?: string;
  channelAccessToken: string;
  defaultHeaders?: Record<string, string>;
}

export class LiffClient {
  private httpClient: HTTPFetchClient;

  constructor(config: httpClientConfig) {
    const baseURL = config.baseURL || "https://api.line.me";
    const defaultHeaders = mergeHeaders(config.defaultHeaders, {
      Authorization: "Bearer " + config.channelAccessToken,
    });
    this.httpClient = new HTTPFetchClient({
      defaultHeaders: defaultHeaders,
      baseURL: baseURL,
    });
  }

  /**
   * Adding the LIFF app to a channel
   * @summary Create LIFF app
   * @param addLiffAppRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/liff-server/#add-liff-app">Create LIFF app Documentation</a>
   */
  public async addLIFFApp(
    addLiffAppRequest: AddLiffAppRequest,
  ): Promise<AddLiffAppResponse> {
    return (await this.addLIFFAppWithHttpInfo(addLiffAppRequest)).body;
  }

  /**
   * Adding the LIFF app to a channel.
   * This method includes HttpInfo object to return additional information.
   * @summary Create LIFF app
   * @param addLiffAppRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/liff-server/#add-liff-app">Create LIFF app Documentation</a>
   */
  public async addLIFFAppWithHttpInfo(
    addLiffAppRequest: AddLiffAppRequest,
  ): Promise<Types.ApiResponseType<AddLiffAppResponse>> {
    const params = addLiffAppRequest;

    const res = await this.httpClient.post("/liff/v1/apps", params);
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Deletes a LIFF app from a channel.
   * @summary Delete LIFF app from a channel
   * @param liffId ID of the LIFF app to be updated
   *
   * @see <a href="https://developers.line.biz/en/reference/liff-server/#delete-liff-app">Delete LIFF app from a channel Documentation</a>
   */
  public async deleteLIFFApp(
    liffId: string,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.deleteLIFFAppWithHttpInfo(liffId)).body;
  }

  /**
   * Deletes a LIFF app from a channel. .
   * This method includes HttpInfo object to return additional information.
   * @summary Delete LIFF app from a channel
   * @param liffId ID of the LIFF app to be updated
   *
   * @see <a href="https://developers.line.biz/en/reference/liff-server/#delete-liff-app">Delete LIFF app from a channel Documentation</a>
   */
  public async deleteLIFFAppWithHttpInfo(
    liffId: string,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const res = await this.httpClient.delete(
      "/liff/v1/apps/{liffId}".replace("{liffId}", String(liffId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Gets information on all the LIFF apps added to the channel.
   * @summary Get all LIFF apps
   *
   * @see <a href="https://developers.line.biz/en/reference/liff-server/#get-all-liff-apps">Get all LIFF apps Documentation</a>
   */
  public async getAllLIFFApps(): Promise<GetAllLiffAppsResponse> {
    return (await this.getAllLIFFAppsWithHttpInfo()).body;
  }

  /**
   * Gets information on all the LIFF apps added to the channel..
   * This method includes HttpInfo object to return additional information.
   * @summary Get all LIFF apps
   *
   * @see <a href="https://developers.line.biz/en/reference/liff-server/#get-all-liff-apps">Get all LIFF apps Documentation</a>
   */
  public async getAllLIFFAppsWithHttpInfo(): Promise<
    Types.ApiResponseType<GetAllLiffAppsResponse>
  > {
    const res = await this.httpClient.get("/liff/v1/apps");
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Update LIFF app settings
   * @summary Update LIFF app from a channel
   * @param liffId ID of the LIFF app to be updated
   * @param updateLiffAppRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/liff-server/#update-liff-app">Update LIFF app from a channel Documentation</a>
   */
  public async updateLIFFApp(
    liffId: string,
    updateLiffAppRequest: UpdateLiffAppRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.updateLIFFAppWithHttpInfo(liffId, updateLiffAppRequest))
      .body;
  }

  /**
   * Update LIFF app settings.
   * This method includes HttpInfo object to return additional information.
   * @summary Update LIFF app from a channel
   * @param liffId ID of the LIFF app to be updated
   * @param updateLiffAppRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/liff-server/#update-liff-app">Update LIFF app from a channel Documentation</a>
   */
  public async updateLIFFAppWithHttpInfo(
    liffId: string,
    updateLiffAppRequest: UpdateLiffAppRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = updateLiffAppRequest;

    const res = await this.httpClient.put(
      "/liff/v1/apps/{liffId}".replace("{liffId}", String(liffId)),
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
}
