/**
 * LINE Messaging API
 * This document describes LINE Messaging API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/* tslint:disable:no-unused-locals */
import { BotInfoResponse } from "../model/botInfoResponse.js";
import { BroadcastRequest } from "../model/broadcastRequest.js";
import { CouponCreateRequest } from "../model/couponCreateRequest.js";
import { CouponCreateResponse } from "../model/couponCreateResponse.js";
import { CouponResponse } from "../model/couponResponse.js";
import { CreateRichMenuAliasRequest } from "../model/createRichMenuAliasRequest.js";
import { ErrorResponse } from "../model/errorResponse.js";
import { GetAggregationUnitNameListResponse } from "../model/getAggregationUnitNameListResponse.js";
import { GetAggregationUnitUsageResponse } from "../model/getAggregationUnitUsageResponse.js";
import { GetFollowersResponse } from "../model/getFollowersResponse.js";
import { GetJoinedMembershipUsersResponse } from "../model/getJoinedMembershipUsersResponse.js";
import { GetMembershipSubscriptionResponse } from "../model/getMembershipSubscriptionResponse.js";
import { GetWebhookEndpointResponse } from "../model/getWebhookEndpointResponse.js";
import { GroupMemberCountResponse } from "../model/groupMemberCountResponse.js";
import { GroupSummaryResponse } from "../model/groupSummaryResponse.js";
import { GroupUserProfileResponse } from "../model/groupUserProfileResponse.js";
import { IssueLinkTokenResponse } from "../model/issueLinkTokenResponse.js";
import { MarkMessagesAsReadByTokenRequest } from "../model/markMessagesAsReadByTokenRequest.js";
import { MarkMessagesAsReadRequest } from "../model/markMessagesAsReadRequest.js";
import { MembersIdsResponse } from "../model/membersIdsResponse.js";
import { MembershipListResponse } from "../model/membershipListResponse.js";
import { MessageQuotaResponse } from "../model/messageQuotaResponse.js";
import { MessagingApiPagerCouponListResponse } from "../model/messagingApiPagerCouponListResponse.js";
import { MulticastRequest } from "../model/multicastRequest.js";
import { NarrowcastProgressResponse } from "../model/narrowcastProgressResponse.js";
import { NarrowcastRequest } from "../model/narrowcastRequest.js";
import { NumberOfMessagesResponse } from "../model/numberOfMessagesResponse.js";
import { PnpMessagesRequest } from "../model/pnpMessagesRequest.js";
import { PushMessageRequest } from "../model/pushMessageRequest.js";
import { PushMessageResponse } from "../model/pushMessageResponse.js";
import { QuotaConsumptionResponse } from "../model/quotaConsumptionResponse.js";
import { ReplyMessageRequest } from "../model/replyMessageRequest.js";
import { ReplyMessageResponse } from "../model/replyMessageResponse.js";
import { RichMenuAliasListResponse } from "../model/richMenuAliasListResponse.js";
import { RichMenuAliasResponse } from "../model/richMenuAliasResponse.js";
import { RichMenuBatchProgressResponse } from "../model/richMenuBatchProgressResponse.js";
import { RichMenuBatchRequest } from "../model/richMenuBatchRequest.js";
import { RichMenuBulkLinkRequest } from "../model/richMenuBulkLinkRequest.js";
import { RichMenuBulkUnlinkRequest } from "../model/richMenuBulkUnlinkRequest.js";
import { RichMenuIdResponse } from "../model/richMenuIdResponse.js";
import { RichMenuListResponse } from "../model/richMenuListResponse.js";
import { RichMenuRequest } from "../model/richMenuRequest.js";
import { RichMenuResponse } from "../model/richMenuResponse.js";
import { RoomMemberCountResponse } from "../model/roomMemberCountResponse.js";
import { RoomUserProfileResponse } from "../model/roomUserProfileResponse.js";
import { SetWebhookEndpointRequest } from "../model/setWebhookEndpointRequest.js";
import { ShowLoadingAnimationRequest } from "../model/showLoadingAnimationRequest.js";
import { TestWebhookEndpointRequest } from "../model/testWebhookEndpointRequest.js";
import { TestWebhookEndpointResponse } from "../model/testWebhookEndpointResponse.js";
import { UpdateRichMenuAliasRequest } from "../model/updateRichMenuAliasRequest.js";
import { UserProfileResponse } from "../model/userProfileResponse.js";
import { ValidateMessageRequest } from "../model/validateMessageRequest.js";

import * as Types from "../../types.js";
import { ensureJSON } from "../../utils.js";
import { Readable } from "node:stream";

import HTTPFetchClient, {
  convertResponseToReadable,
  mergeHeaders,
} from "../../http-fetch.js";

// ===============================================
// This file is autogenerated - Please do not edit
// ===============================================

interface httpClientConfig {
  baseURL?: string;
  channelAccessToken: string;
  defaultHeaders?: Record<string, string>;
}

export class MessagingApiClient {
  private httpClient: HTTPFetchClient;

  constructor(config: httpClientConfig) {
    const baseURL = config.baseURL || "https://api.line.me";
    const defaultHeaders = mergeHeaders(config.defaultHeaders, {
      Authorization: "Bearer " + config.channelAccessToken,
    });
    this.httpClient = new HTTPFetchClient({
      defaultHeaders: defaultHeaders,
      baseURL: baseURL,
    });
  }

  /**
   * Sends a message to multiple users at any time.
   * @param broadcastRequest
   * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-broadcast-message"> Documentation</a>
   */
  public async broadcast(
    broadcastRequest: BroadcastRequest,
    xLineRetryKey?: string,
  ): Promise<object> {
    return (await this.broadcastWithHttpInfo(broadcastRequest, xLineRetryKey))
      .body;
  }

  /**
   * Sends a message to multiple users at any time..
   * This method includes HttpInfo object to return additional information.
   * @param broadcastRequest
   * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-broadcast-message"> Documentation</a>
   */
  public async broadcastWithHttpInfo(
    broadcastRequest: BroadcastRequest,
    xLineRetryKey?: string,
  ): Promise<Types.ApiResponseType<object>> {
    const params = broadcastRequest;

    const headerParams = {
      ...(xLineRetryKey != null ? { "X-Line-Retry-Key": xLineRetryKey } : {}),
    };

    const res = await this.httpClient.post(
      "/v2/bot/message/broadcast",
      params,

      { headers: headerParams },
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Cancel default rich menu
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#cancel-default-rich-menu"> Documentation</a>
   */
  public async cancelDefaultRichMenu(): Promise<Types.MessageAPIResponseBase> {
    return (await this.cancelDefaultRichMenuWithHttpInfo()).body;
  }

  /**
   * Cancel default rich menu.
   * This method includes HttpInfo object to return additional information.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#cancel-default-rich-menu"> Documentation</a>
   */
  public async cancelDefaultRichMenuWithHttpInfo(): Promise<
    Types.ApiResponseType<Types.MessageAPIResponseBase>
  > {
    const res = await this.httpClient.delete("/v2/bot/user/all/richmenu");
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Close coupon
   * @param couponId
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#discontinue-coupon"> Documentation</a>
   */
  public async closeCoupon(
    couponId: string,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.closeCouponWithHttpInfo(couponId)).body;
  }

  /**
   * Close coupon.
   * This method includes HttpInfo object to return additional information.
   * @param couponId
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#discontinue-coupon"> Documentation</a>
   */
  public async closeCouponWithHttpInfo(
    couponId: string,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const res = await this.httpClient.put(
      "/v2/bot/coupon/{couponId}/close".replace("{couponId}", String(couponId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Create a new coupon. Define coupon details such as type, title, and validity period.
   * @param couponCreateRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-coupon"> Documentation</a>
   */
  public async createCoupon(
    couponCreateRequest?: CouponCreateRequest,
  ): Promise<CouponCreateResponse> {
    return (await this.createCouponWithHttpInfo(couponCreateRequest)).body;
  }

  /**
   * Create a new coupon. Define coupon details such as type, title, and validity period..
   * This method includes HttpInfo object to return additional information.
   * @param couponCreateRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-coupon"> Documentation</a>
   */
  public async createCouponWithHttpInfo(
    couponCreateRequest?: CouponCreateRequest,
  ): Promise<Types.ApiResponseType<CouponCreateResponse>> {
    const params = couponCreateRequest;

    const res = await this.httpClient.post("/v2/bot/coupon", params);
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Create rich menu
   * @param richMenuRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-rich-menu"> Documentation</a>
   */
  public async createRichMenu(
    richMenuRequest: RichMenuRequest,
  ): Promise<RichMenuIdResponse> {
    return (await this.createRichMenuWithHttpInfo(richMenuRequest)).body;
  }

  /**
   * Create rich menu.
   * This method includes HttpInfo object to return additional information.
   * @param richMenuRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-rich-menu"> Documentation</a>
   */
  public async createRichMenuWithHttpInfo(
    richMenuRequest: RichMenuRequest,
  ): Promise<Types.ApiResponseType<RichMenuIdResponse>> {
    const params = richMenuRequest;

    const res = await this.httpClient.post("/v2/bot/richmenu", params);
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Create rich menu alias
   * @param createRichMenuAliasRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-rich-menu-alias"> Documentation</a>
   */
  public async createRichMenuAlias(
    createRichMenuAliasRequest: CreateRichMenuAliasRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (
      await this.createRichMenuAliasWithHttpInfo(createRichMenuAliasRequest)
    ).body;
  }

  /**
   * Create rich menu alias.
   * This method includes HttpInfo object to return additional information.
   * @param createRichMenuAliasRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-rich-menu-alias"> Documentation</a>
   */
  public async createRichMenuAliasWithHttpInfo(
    createRichMenuAliasRequest: CreateRichMenuAliasRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = createRichMenuAliasRequest;

    const res = await this.httpClient.post("/v2/bot/richmenu/alias", params);
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Deletes a rich menu.
   * @param richMenuId ID of a rich menu
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#delete-rich-menu"> Documentation</a>
   */
  public async deleteRichMenu(
    richMenuId: string,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.deleteRichMenuWithHttpInfo(richMenuId)).body;
  }

  /**
   * Deletes a rich menu..
   * This method includes HttpInfo object to return additional information.
   * @param richMenuId ID of a rich menu
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#delete-rich-menu"> Documentation</a>
   */
  public async deleteRichMenuWithHttpInfo(
    richMenuId: string,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const res = await this.httpClient.delete(
      "/v2/bot/richmenu/{richMenuId}".replace(
        "{richMenuId}",
        String(richMenuId),
      ),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Delete rich menu alias
   * @param richMenuAliasId Rich menu alias ID that you want to delete.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#delete-rich-menu-alias"> Documentation</a>
   */
  public async deleteRichMenuAlias(
    richMenuAliasId: string,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.deleteRichMenuAliasWithHttpInfo(richMenuAliasId)).body;
  }

  /**
   * Delete rich menu alias.
   * This method includes HttpInfo object to return additional information.
   * @param richMenuAliasId Rich menu alias ID that you want to delete.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#delete-rich-menu-alias"> Documentation</a>
   */
  public async deleteRichMenuAliasWithHttpInfo(
    richMenuAliasId: string,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const res = await this.httpClient.delete(
      "/v2/bot/richmenu/alias/{richMenuAliasId}".replace(
        "{richMenuAliasId}",
        String(richMenuAliasId),
      ),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get name list of units used this month
   * @param limit The maximum number of aggregation units you can get per request.
   * @param start Value of the continuation token found in the next property of the JSON object returned in the response. If you can\'t get all the aggregation units in one request, include this parameter to get the remaining array.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-name-list-of-units-used-this-month"> Documentation</a>
   */
  public async getAggregationUnitNameList(
    limit?: string,
    start?: string,
  ): Promise<GetAggregationUnitNameListResponse> {
    return (await this.getAggregationUnitNameListWithHttpInfo(limit, start))
      .body;
  }

  /**
   * Get name list of units used this month.
   * This method includes HttpInfo object to return additional information.
   * @param limit The maximum number of aggregation units you can get per request.
   * @param start Value of the continuation token found in the next property of the JSON object returned in the response. If you can\'t get all the aggregation units in one request, include this parameter to get the remaining array.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-name-list-of-units-used-this-month"> Documentation</a>
   */
  public async getAggregationUnitNameListWithHttpInfo(
    limit?: string,
    start?: string,
  ): Promise<Types.ApiResponseType<GetAggregationUnitNameListResponse>> {
    const queryParams = {
      limit: limit,
      start: start,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get(
      "/v2/bot/message/aggregation/list",
      queryParams,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get number of units used this month
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-units-used-this-month"> Documentation</a>
   */
  public async getAggregationUnitUsage(): Promise<GetAggregationUnitUsageResponse> {
    return (await this.getAggregationUnitUsageWithHttpInfo()).body;
  }

  /**
   * Get number of units used this month.
   * This method includes HttpInfo object to return additional information.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-units-used-this-month"> Documentation</a>
   */
  public async getAggregationUnitUsageWithHttpInfo(): Promise<
    Types.ApiResponseType<GetAggregationUnitUsageResponse>
  > {
    const res = await this.httpClient.get("/v2/bot/message/aggregation/info");
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get bot info
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-bot-info"> Documentation</a>
   */
  public async getBotInfo(): Promise<BotInfoResponse> {
    return (await this.getBotInfoWithHttpInfo()).body;
  }

  /**
   * Get bot info.
   * This method includes HttpInfo object to return additional information.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-bot-info"> Documentation</a>
   */
  public async getBotInfoWithHttpInfo(): Promise<
    Types.ApiResponseType<BotInfoResponse>
  > {
    const res = await this.httpClient.get("/v2/bot/info");
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get coupon detail
   * @param couponId
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-coupon"> Documentation</a>
   */
  public async getCouponDetail(couponId: string): Promise<CouponResponse> {
    return (await this.getCouponDetailWithHttpInfo(couponId)).body;
  }

  /**
   * Get coupon detail.
   * This method includes HttpInfo object to return additional information.
   * @param couponId
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-coupon"> Documentation</a>
   */
  public async getCouponDetailWithHttpInfo(
    couponId: string,
  ): Promise<Types.ApiResponseType<CouponResponse>> {
    const res = await this.httpClient.get(
      "/v2/bot/coupon/{couponId}".replace("{couponId}", String(couponId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Gets the ID of the default rich menu set with the Messaging API.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-default-rich-menu-id"> Documentation</a>
   */
  public async getDefaultRichMenuId(): Promise<RichMenuIdResponse> {
    return (await this.getDefaultRichMenuIdWithHttpInfo()).body;
  }

  /**
   * Gets the ID of the default rich menu set with the Messaging API..
   * This method includes HttpInfo object to return additional information.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-default-rich-menu-id"> Documentation</a>
   */
  public async getDefaultRichMenuIdWithHttpInfo(): Promise<
    Types.ApiResponseType<RichMenuIdResponse>
  > {
    const res = await this.httpClient.get("/v2/bot/user/all/richmenu");
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get a list of users who added your LINE Official Account as a friend
   * @param start Value of the continuation token found in the next property of the JSON object returned in the response. Include this parameter to get the next array of user IDs.
   * @param limit The maximum number of user IDs to retrieve in a single request.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-follower-ids"> Documentation</a>
   */
  public async getFollowers(
    start?: string,
    limit?: number,
  ): Promise<GetFollowersResponse> {
    return (await this.getFollowersWithHttpInfo(start, limit)).body;
  }

  /**
   * Get a list of users who added your LINE Official Account as a friend.
   * This method includes HttpInfo object to return additional information.
   * @param start Value of the continuation token found in the next property of the JSON object returned in the response. Include this parameter to get the next array of user IDs.
   * @param limit The maximum number of user IDs to retrieve in a single request.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-follower-ids"> Documentation</a>
   */
  public async getFollowersWithHttpInfo(
    start?: string,
    limit?: number,
  ): Promise<Types.ApiResponseType<GetFollowersResponse>> {
    const queryParams = {
      start: start,
      limit: limit,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get("/v2/bot/followers/ids", queryParams);
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get number of users in a group chat
   * @param groupId Group ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-members-group-count"> Documentation</a>
   */
  public async getGroupMemberCount(
    groupId: string,
  ): Promise<GroupMemberCountResponse> {
    return (await this.getGroupMemberCountWithHttpInfo(groupId)).body;
  }

  /**
   * Get number of users in a group chat.
   * This method includes HttpInfo object to return additional information.
   * @param groupId Group ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-members-group-count"> Documentation</a>
   */
  public async getGroupMemberCountWithHttpInfo(
    groupId: string,
  ): Promise<Types.ApiResponseType<GroupMemberCountResponse>> {
    const res = await this.httpClient.get(
      "/v2/bot/group/{groupId}/members/count".replace(
        "{groupId}",
        String(groupId),
      ),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get group chat member profile
   * @param groupId Group ID
   * @param userId User ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-group-member-profile"> Documentation</a>
   */
  public async getGroupMemberProfile(
    groupId: string,
    userId: string,
  ): Promise<GroupUserProfileResponse> {
    return (await this.getGroupMemberProfileWithHttpInfo(groupId, userId)).body;
  }

  /**
   * Get group chat member profile.
   * This method includes HttpInfo object to return additional information.
   * @param groupId Group ID
   * @param userId User ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-group-member-profile"> Documentation</a>
   */
  public async getGroupMemberProfileWithHttpInfo(
    groupId: string,
    userId: string,
  ): Promise<Types.ApiResponseType<GroupUserProfileResponse>> {
    const res = await this.httpClient.get(
      "/v2/bot/group/{groupId}/member/{userId}"

        .replace("{groupId}", String(groupId))

        .replace("{userId}", String(userId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get group chat member user IDs
   * @param groupId Group ID
   * @param start Value of the continuation token found in the `next` property of the JSON object returned in the response. Include this parameter to get the next array of user IDs for the members of the group.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-group-member-user-ids"> Documentation</a>
   */
  public async getGroupMembersIds(
    groupId: string,
    start?: string,
  ): Promise<MembersIdsResponse> {
    return (await this.getGroupMembersIdsWithHttpInfo(groupId, start)).body;
  }

  /**
   * Get group chat member user IDs.
   * This method includes HttpInfo object to return additional information.
   * @param groupId Group ID
   * @param start Value of the continuation token found in the `next` property of the JSON object returned in the response. Include this parameter to get the next array of user IDs for the members of the group.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-group-member-user-ids"> Documentation</a>
   */
  public async getGroupMembersIdsWithHttpInfo(
    groupId: string,
    start?: string,
  ): Promise<Types.ApiResponseType<MembersIdsResponse>> {
    const queryParams = {
      start: start,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get(
      "/v2/bot/group/{groupId}/members/ids".replace(
        "{groupId}",
        String(groupId),
      ),
      queryParams,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get group chat summary
   * @param groupId Group ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-group-summary"> Documentation</a>
   */
  public async getGroupSummary(groupId: string): Promise<GroupSummaryResponse> {
    return (await this.getGroupSummaryWithHttpInfo(groupId)).body;
  }

  /**
   * Get group chat summary.
   * This method includes HttpInfo object to return additional information.
   * @param groupId Group ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-group-summary"> Documentation</a>
   */
  public async getGroupSummaryWithHttpInfo(
    groupId: string,
  ): Promise<Types.ApiResponseType<GroupSummaryResponse>> {
    const res = await this.httpClient.get(
      "/v2/bot/group/{groupId}/summary".replace("{groupId}", String(groupId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get a list of user IDs who joined the membership.
   * @param membershipId Membership plan ID.
   * @param start A continuation token to get next remaining membership user IDs. Returned only when there are remaining user IDs that weren\'t returned in the userIds property in the previous request. The continuation token expires in 24 hours (86,400 seconds).
   * @param limit The max number of items to return for this API call. The value is set to 300 by default, but the max acceptable value is 1000.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-membership-user-ids"> Documentation</a>
   */
  public async getJoinedMembershipUsers(
    membershipId: number,
    start?: string,
    limit?: number,
  ): Promise<GetJoinedMembershipUsersResponse> {
    return (
      await this.getJoinedMembershipUsersWithHttpInfo(
        membershipId,
        start,
        limit,
      )
    ).body;
  }

  /**
   * Get a list of user IDs who joined the membership..
   * This method includes HttpInfo object to return additional information.
   * @param membershipId Membership plan ID.
   * @param start A continuation token to get next remaining membership user IDs. Returned only when there are remaining user IDs that weren\'t returned in the userIds property in the previous request. The continuation token expires in 24 hours (86,400 seconds).
   * @param limit The max number of items to return for this API call. The value is set to 300 by default, but the max acceptable value is 1000.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-membership-user-ids"> Documentation</a>
   */
  public async getJoinedMembershipUsersWithHttpInfo(
    membershipId: number,
    start?: string,
    limit?: number,
  ): Promise<Types.ApiResponseType<GetJoinedMembershipUsersResponse>> {
    const queryParams = {
      start: start,
      limit: limit,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get(
      "/v2/bot/membership/{membershipId}/users/ids".replace(
        "{membershipId}",
        String(membershipId),
      ),
      queryParams,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get a list of memberships.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-membership-plans"> Documentation</a>
   */
  public async getMembershipList(): Promise<MembershipListResponse> {
    return (await this.getMembershipListWithHttpInfo()).body;
  }

  /**
   * Get a list of memberships..
   * This method includes HttpInfo object to return additional information.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-membership-plans"> Documentation</a>
   */
  public async getMembershipListWithHttpInfo(): Promise<
    Types.ApiResponseType<MembershipListResponse>
  > {
    const res = await this.httpClient.get("/v2/bot/membership/list");
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get a user\'s membership subscription.
   * @param userId User ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-a-users-membership-subscription-status"> Documentation</a>
   */
  public async getMembershipSubscription(
    userId: string,
  ): Promise<GetMembershipSubscriptionResponse> {
    return (await this.getMembershipSubscriptionWithHttpInfo(userId)).body;
  }

  /**
   * Get a user\'s membership subscription..
   * This method includes HttpInfo object to return additional information.
   * @param userId User ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-a-users-membership-subscription-status"> Documentation</a>
   */
  public async getMembershipSubscriptionWithHttpInfo(
    userId: string,
  ): Promise<Types.ApiResponseType<GetMembershipSubscriptionResponse>> {
    const res = await this.httpClient.get(
      "/v2/bot/membership/subscription/{userId}".replace(
        "{userId}",
        String(userId),
      ),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Gets the target limit for sending messages in the current month. The total number of the free messages and the additional messages is returned.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-quota"> Documentation</a>
   */
  public async getMessageQuota(): Promise<MessageQuotaResponse> {
    return (await this.getMessageQuotaWithHttpInfo()).body;
  }

  /**
   * Gets the target limit for sending messages in the current month. The total number of the free messages and the additional messages is returned..
   * This method includes HttpInfo object to return additional information.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-quota"> Documentation</a>
   */
  public async getMessageQuotaWithHttpInfo(): Promise<
    Types.ApiResponseType<MessageQuotaResponse>
  > {
    const res = await this.httpClient.get("/v2/bot/message/quota");
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Gets the number of messages sent in the current month.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-consumption"> Documentation</a>
   */
  public async getMessageQuotaConsumption(): Promise<QuotaConsumptionResponse> {
    return (await this.getMessageQuotaConsumptionWithHttpInfo()).body;
  }

  /**
   * Gets the number of messages sent in the current month..
   * This method includes HttpInfo object to return additional information.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-consumption"> Documentation</a>
   */
  public async getMessageQuotaConsumptionWithHttpInfo(): Promise<
    Types.ApiResponseType<QuotaConsumptionResponse>
  > {
    const res = await this.httpClient.get("/v2/bot/message/quota/consumption");
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Gets the status of a narrowcast message.
   * @param requestId The narrowcast message\'s request ID. Each Messaging API request has a request ID.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-narrowcast-progress-status"> Documentation</a>
   */
  public async getNarrowcastProgress(
    requestId: string,
  ): Promise<NarrowcastProgressResponse> {
    return (await this.getNarrowcastProgressWithHttpInfo(requestId)).body;
  }

  /**
   * Gets the status of a narrowcast message..
   * This method includes HttpInfo object to return additional information.
   * @param requestId The narrowcast message\'s request ID. Each Messaging API request has a request ID.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-narrowcast-progress-status"> Documentation</a>
   */
  public async getNarrowcastProgressWithHttpInfo(
    requestId: string,
  ): Promise<Types.ApiResponseType<NarrowcastProgressResponse>> {
    const queryParams = {
      requestId: requestId,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get(
      "/v2/bot/message/progress/narrowcast",
      queryParams,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get number of sent broadcast messages
   * @param date Date the messages were sent  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-broadcast-messages"> Documentation</a>
   */
  public async getNumberOfSentBroadcastMessages(
    date: string,
  ): Promise<NumberOfMessagesResponse> {
    return (await this.getNumberOfSentBroadcastMessagesWithHttpInfo(date)).body;
  }

  /**
   * Get number of sent broadcast messages.
   * This method includes HttpInfo object to return additional information.
   * @param date Date the messages were sent  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-broadcast-messages"> Documentation</a>
   */
  public async getNumberOfSentBroadcastMessagesWithHttpInfo(
    date: string,
  ): Promise<Types.ApiResponseType<NumberOfMessagesResponse>> {
    const queryParams = {
      date: date,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get(
      "/v2/bot/message/delivery/broadcast",
      queryParams,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get number of sent multicast messages
   * @param date Date the messages were sent  Format: `yyyyMMdd` (e.g. `20191231`) Timezone: UTC+9
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-multicast-messages"> Documentation</a>
   */
  public async getNumberOfSentMulticastMessages(
    date: string,
  ): Promise<NumberOfMessagesResponse> {
    return (await this.getNumberOfSentMulticastMessagesWithHttpInfo(date)).body;
  }

  /**
   * Get number of sent multicast messages.
   * This method includes HttpInfo object to return additional information.
   * @param date Date the messages were sent  Format: `yyyyMMdd` (e.g. `20191231`) Timezone: UTC+9
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-multicast-messages"> Documentation</a>
   */
  public async getNumberOfSentMulticastMessagesWithHttpInfo(
    date: string,
  ): Promise<Types.ApiResponseType<NumberOfMessagesResponse>> {
    const queryParams = {
      date: date,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get(
      "/v2/bot/message/delivery/multicast",
      queryParams,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get number of sent push messages
   * @param date Date the messages were sent  Format: `yyyyMMdd` (e.g. `20191231`) Timezone: UTC+9
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-push-messages"> Documentation</a>
   */
  public async getNumberOfSentPushMessages(
    date: string,
  ): Promise<NumberOfMessagesResponse> {
    return (await this.getNumberOfSentPushMessagesWithHttpInfo(date)).body;
  }

  /**
   * Get number of sent push messages.
   * This method includes HttpInfo object to return additional information.
   * @param date Date the messages were sent  Format: `yyyyMMdd` (e.g. `20191231`) Timezone: UTC+9
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-push-messages"> Documentation</a>
   */
  public async getNumberOfSentPushMessagesWithHttpInfo(
    date: string,
  ): Promise<Types.ApiResponseType<NumberOfMessagesResponse>> {
    const queryParams = {
      date: date,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get(
      "/v2/bot/message/delivery/push",
      queryParams,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get number of sent reply messages
   * @param date Date the messages were sent  Format: `yyyyMMdd` (e.g. `20191231`) Timezone: UTC+9
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-reply-messages"> Documentation</a>
   */
  public async getNumberOfSentReplyMessages(
    date: string,
  ): Promise<NumberOfMessagesResponse> {
    return (await this.getNumberOfSentReplyMessagesWithHttpInfo(date)).body;
  }

  /**
   * Get number of sent reply messages.
   * This method includes HttpInfo object to return additional information.
   * @param date Date the messages were sent  Format: `yyyyMMdd` (e.g. `20191231`) Timezone: UTC+9
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-reply-messages"> Documentation</a>
   */
  public async getNumberOfSentReplyMessagesWithHttpInfo(
    date: string,
  ): Promise<Types.ApiResponseType<NumberOfMessagesResponse>> {
    const queryParams = {
      date: date,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get(
      "/v2/bot/message/delivery/reply",
      queryParams,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get number of sent LINE notification messages
   * @param date Date the message was sent  Format: `yyyyMMdd` (Example:`20211231`) Time zone: UTC+9
   *
   * @see <a href="https://developers.line.biz/en/reference/partner-docs/#get-number-of-sent-line-notification-messages"> Documentation</a>
   */
  public async getPNPMessageStatistics(
    date: string,
  ): Promise<NumberOfMessagesResponse> {
    return (await this.getPNPMessageStatisticsWithHttpInfo(date)).body;
  }

  /**
   * Get number of sent LINE notification messages　.
   * This method includes HttpInfo object to return additional information.
   * @param date Date the message was sent  Format: `yyyyMMdd` (Example:`20211231`) Time zone: UTC+9
   *
   * @see <a href="https://developers.line.biz/en/reference/partner-docs/#get-number-of-sent-line-notification-messages"> Documentation</a>
   */
  public async getPNPMessageStatisticsWithHttpInfo(
    date: string,
  ): Promise<Types.ApiResponseType<NumberOfMessagesResponse>> {
    const queryParams = {
      date: date,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get(
      "/v2/bot/message/delivery/pnp",
      queryParams,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get profile
   * @param userId User ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-profile"> Documentation</a>
   */
  public async getProfile(userId: string): Promise<UserProfileResponse> {
    return (await this.getProfileWithHttpInfo(userId)).body;
  }

  /**
   * Get profile.
   * This method includes HttpInfo object to return additional information.
   * @param userId User ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-profile"> Documentation</a>
   */
  public async getProfileWithHttpInfo(
    userId: string,
  ): Promise<Types.ApiResponseType<UserProfileResponse>> {
    const res = await this.httpClient.get(
      "/v2/bot/profile/{userId}".replace("{userId}", String(userId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Gets a rich menu via a rich menu ID.
   * @param richMenuId ID of a rich menu
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu"> Documentation</a>
   */
  public async getRichMenu(richMenuId: string): Promise<RichMenuResponse> {
    return (await this.getRichMenuWithHttpInfo(richMenuId)).body;
  }

  /**
   * Gets a rich menu via a rich menu ID..
   * This method includes HttpInfo object to return additional information.
   * @param richMenuId ID of a rich menu
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu"> Documentation</a>
   */
  public async getRichMenuWithHttpInfo(
    richMenuId: string,
  ): Promise<Types.ApiResponseType<RichMenuResponse>> {
    const res = await this.httpClient.get(
      "/v2/bot/richmenu/{richMenuId}".replace(
        "{richMenuId}",
        String(richMenuId),
      ),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get rich menu alias information
   * @param richMenuAliasId The rich menu alias ID whose information you want to obtain.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-alias-by-id"> Documentation</a>
   */
  public async getRichMenuAlias(
    richMenuAliasId: string,
  ): Promise<RichMenuAliasResponse> {
    return (await this.getRichMenuAliasWithHttpInfo(richMenuAliasId)).body;
  }

  /**
   * Get rich menu alias information.
   * This method includes HttpInfo object to return additional information.
   * @param richMenuAliasId The rich menu alias ID whose information you want to obtain.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-alias-by-id"> Documentation</a>
   */
  public async getRichMenuAliasWithHttpInfo(
    richMenuAliasId: string,
  ): Promise<Types.ApiResponseType<RichMenuAliasResponse>> {
    const res = await this.httpClient.get(
      "/v2/bot/richmenu/alias/{richMenuAliasId}".replace(
        "{richMenuAliasId}",
        String(richMenuAliasId),
      ),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get list of rich menu alias
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-alias-list"> Documentation</a>
   */
  public async getRichMenuAliasList(): Promise<RichMenuAliasListResponse> {
    return (await this.getRichMenuAliasListWithHttpInfo()).body;
  }

  /**
   * Get list of rich menu alias.
   * This method includes HttpInfo object to return additional information.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-alias-list"> Documentation</a>
   */
  public async getRichMenuAliasListWithHttpInfo(): Promise<
    Types.ApiResponseType<RichMenuAliasListResponse>
  > {
    const res = await this.httpClient.get("/v2/bot/richmenu/alias/list");
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get the status of Replace or unlink a linked rich menus in batches.
   * @param requestId A request ID used to batch control the rich menu linked to the user. Each Messaging API request has a request ID.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-batch-control-rich-menus-progress-status"> Documentation</a>
   */
  public async getRichMenuBatchProgress(
    requestId: string,
  ): Promise<RichMenuBatchProgressResponse> {
    return (await this.getRichMenuBatchProgressWithHttpInfo(requestId)).body;
  }

  /**
   * Get the status of Replace or unlink a linked rich menus in batches..
   * This method includes HttpInfo object to return additional information.
   * @param requestId A request ID used to batch control the rich menu linked to the user. Each Messaging API request has a request ID.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-batch-control-rich-menus-progress-status"> Documentation</a>
   */
  public async getRichMenuBatchProgressWithHttpInfo(
    requestId: string,
  ): Promise<Types.ApiResponseType<RichMenuBatchProgressResponse>> {
    const queryParams = {
      requestId: requestId,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get(
      "/v2/bot/richmenu/progress/batch",
      queryParams,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get rich menu ID of user
   * @param userId User ID. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-id-of-user"> Documentation</a>
   */
  public async getRichMenuIdOfUser(
    userId: string,
  ): Promise<RichMenuIdResponse> {
    return (await this.getRichMenuIdOfUserWithHttpInfo(userId)).body;
  }

  /**
   * Get rich menu ID of user.
   * This method includes HttpInfo object to return additional information.
   * @param userId User ID. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-id-of-user"> Documentation</a>
   */
  public async getRichMenuIdOfUserWithHttpInfo(
    userId: string,
  ): Promise<Types.ApiResponseType<RichMenuIdResponse>> {
    const res = await this.httpClient.get(
      "/v2/bot/user/{userId}/richmenu".replace("{userId}", String(userId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get rich menu list
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-list"> Documentation</a>
   */
  public async getRichMenuList(): Promise<RichMenuListResponse> {
    return (await this.getRichMenuListWithHttpInfo()).body;
  }

  /**
   * Get rich menu list.
   * This method includes HttpInfo object to return additional information.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-list"> Documentation</a>
   */
  public async getRichMenuListWithHttpInfo(): Promise<
    Types.ApiResponseType<RichMenuListResponse>
  > {
    const res = await this.httpClient.get("/v2/bot/richmenu/list");
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get number of users in a multi-person chat
   * @param roomId Room ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-members-room-count"> Documentation</a>
   */
  public async getRoomMemberCount(
    roomId: string,
  ): Promise<RoomMemberCountResponse> {
    return (await this.getRoomMemberCountWithHttpInfo(roomId)).body;
  }

  /**
   * Get number of users in a multi-person chat.
   * This method includes HttpInfo object to return additional information.
   * @param roomId Room ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-members-room-count"> Documentation</a>
   */
  public async getRoomMemberCountWithHttpInfo(
    roomId: string,
  ): Promise<Types.ApiResponseType<RoomMemberCountResponse>> {
    const res = await this.httpClient.get(
      "/v2/bot/room/{roomId}/members/count".replace("{roomId}", String(roomId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get multi-person chat member profile
   * @param roomId Room ID
   * @param userId User ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-room-member-profile"> Documentation</a>
   */
  public async getRoomMemberProfile(
    roomId: string,
    userId: string,
  ): Promise<RoomUserProfileResponse> {
    return (await this.getRoomMemberProfileWithHttpInfo(roomId, userId)).body;
  }

  /**
   * Get multi-person chat member profile.
   * This method includes HttpInfo object to return additional information.
   * @param roomId Room ID
   * @param userId User ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-room-member-profile"> Documentation</a>
   */
  public async getRoomMemberProfileWithHttpInfo(
    roomId: string,
    userId: string,
  ): Promise<Types.ApiResponseType<RoomUserProfileResponse>> {
    const res = await this.httpClient.get(
      "/v2/bot/room/{roomId}/member/{userId}"

        .replace("{roomId}", String(roomId))

        .replace("{userId}", String(userId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get multi-person chat member user IDs
   * @param roomId Room ID
   * @param start Value of the continuation token found in the `next` property of the JSON object returned in the response. Include this parameter to get the next array of user IDs for the members of the group.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-room-member-user-ids"> Documentation</a>
   */
  public async getRoomMembersIds(
    roomId: string,
    start?: string,
  ): Promise<MembersIdsResponse> {
    return (await this.getRoomMembersIdsWithHttpInfo(roomId, start)).body;
  }

  /**
   * Get multi-person chat member user IDs.
   * This method includes HttpInfo object to return additional information.
   * @param roomId Room ID
   * @param start Value of the continuation token found in the `next` property of the JSON object returned in the response. Include this parameter to get the next array of user IDs for the members of the group.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-room-member-user-ids"> Documentation</a>
   */
  public async getRoomMembersIdsWithHttpInfo(
    roomId: string,
    start?: string,
  ): Promise<Types.ApiResponseType<MembersIdsResponse>> {
    const queryParams = {
      start: start,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get(
      "/v2/bot/room/{roomId}/members/ids".replace("{roomId}", String(roomId)),
      queryParams,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get webhook endpoint information
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-webhook-endpoint-information"> Documentation</a>
   */
  public async getWebhookEndpoint(): Promise<GetWebhookEndpointResponse> {
    return (await this.getWebhookEndpointWithHttpInfo()).body;
  }

  /**
   * Get webhook endpoint information.
   * This method includes HttpInfo object to return additional information.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-webhook-endpoint-information"> Documentation</a>
   */
  public async getWebhookEndpointWithHttpInfo(): Promise<
    Types.ApiResponseType<GetWebhookEndpointResponse>
  > {
    const res = await this.httpClient.get("/v2/bot/channel/webhook/endpoint");
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Issue link token
   * @param userId User ID for the LINE account to be linked. Found in the `source` object of account link event objects. Do not use the LINE ID used in LINE.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-link-token"> Documentation</a>
   */
  public async issueLinkToken(userId: string): Promise<IssueLinkTokenResponse> {
    return (await this.issueLinkTokenWithHttpInfo(userId)).body;
  }

  /**
   * Issue link token.
   * This method includes HttpInfo object to return additional information.
   * @param userId User ID for the LINE account to be linked. Found in the `source` object of account link event objects. Do not use the LINE ID used in LINE.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-link-token"> Documentation</a>
   */
  public async issueLinkTokenWithHttpInfo(
    userId: string,
  ): Promise<Types.ApiResponseType<IssueLinkTokenResponse>> {
    const res = await this.httpClient.post(
      "/v2/bot/user/{userId}/linkToken".replace("{userId}", String(userId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Leave group chat
   * @param groupId Group ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#leave-group"> Documentation</a>
   */
  public async leaveGroup(
    groupId: string,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.leaveGroupWithHttpInfo(groupId)).body;
  }

  /**
   * Leave group chat.
   * This method includes HttpInfo object to return additional information.
   * @param groupId Group ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#leave-group"> Documentation</a>
   */
  public async leaveGroupWithHttpInfo(
    groupId: string,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const res = await this.httpClient.post(
      "/v2/bot/group/{groupId}/leave".replace("{groupId}", String(groupId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Leave multi-person chat
   * @param roomId Room ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#leave-room"> Documentation</a>
   */
  public async leaveRoom(
    roomId: string,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.leaveRoomWithHttpInfo(roomId)).body;
  }

  /**
   * Leave multi-person chat.
   * This method includes HttpInfo object to return additional information.
   * @param roomId Room ID
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#leave-room"> Documentation</a>
   */
  public async leaveRoomWithHttpInfo(
    roomId: string,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const res = await this.httpClient.post(
      "/v2/bot/room/{roomId}/leave".replace("{roomId}", String(roomId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Link rich menu to user.
   * @param userId User ID. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.
   * @param richMenuId ID of a rich menu
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#link-rich-menu-to-user"> Documentation</a>
   */
  public async linkRichMenuIdToUser(
    userId: string,
    richMenuId: string,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.linkRichMenuIdToUserWithHttpInfo(userId, richMenuId))
      .body;
  }

  /**
   * Link rich menu to user..
   * This method includes HttpInfo object to return additional information.
   * @param userId User ID. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.
   * @param richMenuId ID of a rich menu
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#link-rich-menu-to-user"> Documentation</a>
   */
  public async linkRichMenuIdToUserWithHttpInfo(
    userId: string,
    richMenuId: string,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const res = await this.httpClient.post(
      "/v2/bot/user/{userId}/richmenu/{richMenuId}"

        .replace("{userId}", String(userId))

        .replace("{richMenuId}", String(richMenuId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Link rich menu to multiple users
   * @param richMenuBulkLinkRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#link-rich-menu-to-users"> Documentation</a>
   */
  public async linkRichMenuIdToUsers(
    richMenuBulkLinkRequest: RichMenuBulkLinkRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (
      await this.linkRichMenuIdToUsersWithHttpInfo(richMenuBulkLinkRequest)
    ).body;
  }

  /**
   * Link rich menu to multiple users.
   * This method includes HttpInfo object to return additional information.
   * @param richMenuBulkLinkRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#link-rich-menu-to-users"> Documentation</a>
   */
  public async linkRichMenuIdToUsersWithHttpInfo(
    richMenuBulkLinkRequest: RichMenuBulkLinkRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = richMenuBulkLinkRequest;

    const res = await this.httpClient.post(
      "/v2/bot/richmenu/bulk/link",
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Get a paginated list of coupons.
   * @param status Filter coupons by their status.
   * @param start Pagination token to retrieve the next page of results.
   * @param limit Maximum number of coupons to return per request.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-coupons-list"> Documentation</a>
   */
  public async listCoupon(
    status?: Set<"DRAFT" | "RUNNING" | "CLOSED">,
    start?: string,
    limit?: number,
  ): Promise<MessagingApiPagerCouponListResponse> {
    return (await this.listCouponWithHttpInfo(status, start, limit)).body;
  }

  /**
   * Get a paginated list of coupons..
   * This method includes HttpInfo object to return additional information.
   * @param status Filter coupons by their status.
   * @param start Pagination token to retrieve the next page of results.
   * @param limit Maximum number of coupons to return per request.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-coupons-list"> Documentation</a>
   */
  public async listCouponWithHttpInfo(
    status?: Set<"DRAFT" | "RUNNING" | "CLOSED">,
    start?: string,
    limit?: number,
  ): Promise<Types.ApiResponseType<MessagingApiPagerCouponListResponse>> {
    const queryParams = {
      status: [...status].join(","),
      start: start,
      limit: limit,
    };
    Object.keys(queryParams).forEach((key: keyof typeof queryParams) => {
      if (queryParams[key] === undefined) {
        delete queryParams[key];
      }
    });

    const res = await this.httpClient.get("/v2/bot/coupon", queryParams);
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Mark messages from users as read
   * @param markMessagesAsReadRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/partner-docs/#mark-messages-from-users-as-read"> Documentation</a>
   */
  public async markMessagesAsRead(
    markMessagesAsReadRequest: MarkMessagesAsReadRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (
      await this.markMessagesAsReadWithHttpInfo(markMessagesAsReadRequest)
    ).body;
  }

  /**
   * Mark messages from users as read.
   * This method includes HttpInfo object to return additional information.
   * @param markMessagesAsReadRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/partner-docs/#mark-messages-from-users-as-read"> Documentation</a>
   */
  public async markMessagesAsReadWithHttpInfo(
    markMessagesAsReadRequest: MarkMessagesAsReadRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = markMessagesAsReadRequest;

    const res = await this.httpClient.post(
      "/v2/bot/message/markAsRead",
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Mark messages from users as read by token
   * @param markMessagesAsReadByTokenRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#mark-as-read"> Documentation</a>
   */
  public async markMessagesAsReadByToken(
    markMessagesAsReadByTokenRequest: MarkMessagesAsReadByTokenRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (
      await this.markMessagesAsReadByTokenWithHttpInfo(
        markMessagesAsReadByTokenRequest,
      )
    ).body;
  }

  /**
   * Mark messages from users as read by token.
   * This method includes HttpInfo object to return additional information.
   * @param markMessagesAsReadByTokenRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#mark-as-read"> Documentation</a>
   */
  public async markMessagesAsReadByTokenWithHttpInfo(
    markMessagesAsReadByTokenRequest: MarkMessagesAsReadByTokenRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = markMessagesAsReadByTokenRequest;

    const res = await this.httpClient.post("/v2/bot/chat/markAsRead", params);
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * An API that efficiently sends the same message to multiple user IDs. You can\'t send messages to group chats or multi-person chats.
   * @param multicastRequest
   * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-multicast-message"> Documentation</a>
   */
  public async multicast(
    multicastRequest: MulticastRequest,
    xLineRetryKey?: string,
  ): Promise<object> {
    return (await this.multicastWithHttpInfo(multicastRequest, xLineRetryKey))
      .body;
  }

  /**
   * An API that efficiently sends the same message to multiple user IDs. You can\'t send messages to group chats or multi-person chats..
   * This method includes HttpInfo object to return additional information.
   * @param multicastRequest
   * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-multicast-message"> Documentation</a>
   */
  public async multicastWithHttpInfo(
    multicastRequest: MulticastRequest,
    xLineRetryKey?: string,
  ): Promise<Types.ApiResponseType<object>> {
    const params = multicastRequest;

    const headerParams = {
      ...(xLineRetryKey != null ? { "X-Line-Retry-Key": xLineRetryKey } : {}),
    };

    const res = await this.httpClient.post(
      "/v2/bot/message/multicast",
      params,

      { headers: headerParams },
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Send narrowcast message
   * @param narrowcastRequest
   * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-narrowcast-message"> Documentation</a>
   */
  public async narrowcast(
    narrowcastRequest: NarrowcastRequest,
    xLineRetryKey?: string,
  ): Promise<object> {
    return (await this.narrowcastWithHttpInfo(narrowcastRequest, xLineRetryKey))
      .body;
  }

  /**
   * Send narrowcast message.
   * This method includes HttpInfo object to return additional information.
   * @param narrowcastRequest
   * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-narrowcast-message"> Documentation</a>
   */
  public async narrowcastWithHttpInfo(
    narrowcastRequest: NarrowcastRequest,
    xLineRetryKey?: string,
  ): Promise<Types.ApiResponseType<object>> {
    const params = narrowcastRequest;

    const headerParams = {
      ...(xLineRetryKey != null ? { "X-Line-Retry-Key": xLineRetryKey } : {}),
    };

    const res = await this.httpClient.post(
      "/v2/bot/message/narrowcast",
      params,

      { headers: headerParams },
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Sends a message to a user, group chat, or multi-person chat at any time.
   * @param pushMessageRequest
   * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-push-message"> Documentation</a>
   */
  public async pushMessage(
    pushMessageRequest: PushMessageRequest,
    xLineRetryKey?: string,
  ): Promise<PushMessageResponse> {
    return (
      await this.pushMessageWithHttpInfo(pushMessageRequest, xLineRetryKey)
    ).body;
  }

  /**
   * Sends a message to a user, group chat, or multi-person chat at any time..
   * This method includes HttpInfo object to return additional information.
   * @param pushMessageRequest
   * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-push-message"> Documentation</a>
   */
  public async pushMessageWithHttpInfo(
    pushMessageRequest: PushMessageRequest,
    xLineRetryKey?: string,
  ): Promise<Types.ApiResponseType<PushMessageResponse>> {
    const params = pushMessageRequest;

    const headerParams = {
      ...(xLineRetryKey != null ? { "X-Line-Retry-Key": xLineRetryKey } : {}),
    };

    const res = await this.httpClient.post(
      "/v2/bot/message/push",
      params,

      { headers: headerParams },
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Send LINE notification message
   * @param pnpMessagesRequest
   * @param xLineDeliveryTag String returned in the delivery.data property of the delivery completion event via Webhook.
   *
   * @see <a href="https://developers.line.biz/en/reference/partner-docs/#send-line-notification-message"> Documentation</a>
   */
  public async pushMessagesByPhone(
    pnpMessagesRequest: PnpMessagesRequest,
    xLineDeliveryTag?: string,
  ): Promise<Types.MessageAPIResponseBase> {
    return (
      await this.pushMessagesByPhoneWithHttpInfo(
        pnpMessagesRequest,
        xLineDeliveryTag,
      )
    ).body;
  }

  /**
   * Send LINE notification message.
   * This method includes HttpInfo object to return additional information.
   * @param pnpMessagesRequest
   * @param xLineDeliveryTag String returned in the delivery.data property of the delivery completion event via Webhook.
   *
   * @see <a href="https://developers.line.biz/en/reference/partner-docs/#send-line-notification-message"> Documentation</a>
   */
  public async pushMessagesByPhoneWithHttpInfo(
    pnpMessagesRequest: PnpMessagesRequest,
    xLineDeliveryTag?: string,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = pnpMessagesRequest;

    const headerParams = {
      ...(xLineDeliveryTag != null
        ? { "X-Line-Delivery-Tag": xLineDeliveryTag }
        : {}),
    };

    const res = await this.httpClient.post(
      "/bot/pnp/push",
      params,

      { headers: headerParams },
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Send reply message
   * @param replyMessageRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-reply-message"> Documentation</a>
   */
  public async replyMessage(
    replyMessageRequest: ReplyMessageRequest,
  ): Promise<ReplyMessageResponse> {
    return (await this.replyMessageWithHttpInfo(replyMessageRequest)).body;
  }

  /**
   * Send reply message.
   * This method includes HttpInfo object to return additional information.
   * @param replyMessageRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-reply-message"> Documentation</a>
   */
  public async replyMessageWithHttpInfo(
    replyMessageRequest: ReplyMessageRequest,
  ): Promise<Types.ApiResponseType<ReplyMessageResponse>> {
    const params = replyMessageRequest;

    const res = await this.httpClient.post("/v2/bot/message/reply", params);
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * You can use this endpoint to batch control the rich menu linked to the users using the endpoint such as Link rich menu to user. The following operations are available:  1. Replace a rich menu with another rich menu for all users linked to a specific rich menu 2. Unlink a rich menu for all users linked to a specific rich menu 3. Unlink a rich menu for all users linked the rich menu
   * @param richMenuBatchRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#batch-control-rich-menus-of-users"> Documentation</a>
   */
  public async richMenuBatch(
    richMenuBatchRequest: RichMenuBatchRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.richMenuBatchWithHttpInfo(richMenuBatchRequest)).body;
  }

  /**
   * You can use this endpoint to batch control the rich menu linked to the users using the endpoint such as Link rich menu to user. The following operations are available:  1. Replace a rich menu with another rich menu for all users linked to a specific rich menu 2. Unlink a rich menu for all users linked to a specific rich menu 3. Unlink a rich menu for all users linked the rich menu .
   * This method includes HttpInfo object to return additional information.
   * @param richMenuBatchRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#batch-control-rich-menus-of-users"> Documentation</a>
   */
  public async richMenuBatchWithHttpInfo(
    richMenuBatchRequest: RichMenuBatchRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = richMenuBatchRequest;

    const res = await this.httpClient.post("/v2/bot/richmenu/batch", params);
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Set default rich menu
   * @param richMenuId ID of a rich menu
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#set-default-rich-menu"> Documentation</a>
   */
  public async setDefaultRichMenu(
    richMenuId: string,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.setDefaultRichMenuWithHttpInfo(richMenuId)).body;
  }

  /**
   * Set default rich menu.
   * This method includes HttpInfo object to return additional information.
   * @param richMenuId ID of a rich menu
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#set-default-rich-menu"> Documentation</a>
   */
  public async setDefaultRichMenuWithHttpInfo(
    richMenuId: string,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const res = await this.httpClient.post(
      "/v2/bot/user/all/richmenu/{richMenuId}".replace(
        "{richMenuId}",
        String(richMenuId),
      ),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Set webhook endpoint URL
   * @param setWebhookEndpointRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#set-webhook-endpoint-url"> Documentation</a>
   */
  public async setWebhookEndpoint(
    setWebhookEndpointRequest: SetWebhookEndpointRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (
      await this.setWebhookEndpointWithHttpInfo(setWebhookEndpointRequest)
    ).body;
  }

  /**
   * Set webhook endpoint URL.
   * This method includes HttpInfo object to return additional information.
   * @param setWebhookEndpointRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#set-webhook-endpoint-url"> Documentation</a>
   */
  public async setWebhookEndpointWithHttpInfo(
    setWebhookEndpointRequest: SetWebhookEndpointRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = setWebhookEndpointRequest;

    const res = await this.httpClient.put(
      "/v2/bot/channel/webhook/endpoint",
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Display a loading animation in one-on-one chats between users and LINE Official Accounts.
   * @param showLoadingAnimationRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#display-a-loading-indicator"> Documentation</a>
   */
  public async showLoadingAnimation(
    showLoadingAnimationRequest: ShowLoadingAnimationRequest,
  ): Promise<object> {
    return (
      await this.showLoadingAnimationWithHttpInfo(showLoadingAnimationRequest)
    ).body;
  }

  /**
   * Display a loading animation in one-on-one chats between users and LINE Official Accounts..
   * This method includes HttpInfo object to return additional information.
   * @param showLoadingAnimationRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#display-a-loading-indicator"> Documentation</a>
   */
  public async showLoadingAnimationWithHttpInfo(
    showLoadingAnimationRequest: ShowLoadingAnimationRequest,
  ): Promise<Types.ApiResponseType<object>> {
    const params = showLoadingAnimationRequest;

    const res = await this.httpClient.post(
      "/v2/bot/chat/loading/start",
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Test webhook endpoint
   * @param testWebhookEndpointRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#test-webhook-endpoint"> Documentation</a>
   */
  public async testWebhookEndpoint(
    testWebhookEndpointRequest?: TestWebhookEndpointRequest,
  ): Promise<TestWebhookEndpointResponse> {
    return (
      await this.testWebhookEndpointWithHttpInfo(testWebhookEndpointRequest)
    ).body;
  }

  /**
   * Test webhook endpoint.
   * This method includes HttpInfo object to return additional information.
   * @param testWebhookEndpointRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#test-webhook-endpoint"> Documentation</a>
   */
  public async testWebhookEndpointWithHttpInfo(
    testWebhookEndpointRequest?: TestWebhookEndpointRequest,
  ): Promise<Types.ApiResponseType<TestWebhookEndpointResponse>> {
    const params = testWebhookEndpointRequest;

    const res = await this.httpClient.post(
      "/v2/bot/channel/webhook/test",
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Unlink rich menu from user
   * @param userId User ID. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#unlink-rich-menu-from-user"> Documentation</a>
   */
  public async unlinkRichMenuIdFromUser(
    userId: string,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.unlinkRichMenuIdFromUserWithHttpInfo(userId)).body;
  }

  /**
   * Unlink rich menu from user.
   * This method includes HttpInfo object to return additional information.
   * @param userId User ID. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#unlink-rich-menu-from-user"> Documentation</a>
   */
  public async unlinkRichMenuIdFromUserWithHttpInfo(
    userId: string,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const res = await this.httpClient.delete(
      "/v2/bot/user/{userId}/richmenu".replace("{userId}", String(userId)),
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Unlink rich menus from multiple users
   * @param richMenuBulkUnlinkRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#unlink-rich-menu-from-users"> Documentation</a>
   */
  public async unlinkRichMenuIdFromUsers(
    richMenuBulkUnlinkRequest: RichMenuBulkUnlinkRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (
      await this.unlinkRichMenuIdFromUsersWithHttpInfo(
        richMenuBulkUnlinkRequest,
      )
    ).body;
  }

  /**
   * Unlink rich menus from multiple users.
   * This method includes HttpInfo object to return additional information.
   * @param richMenuBulkUnlinkRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#unlink-rich-menu-from-users"> Documentation</a>
   */
  public async unlinkRichMenuIdFromUsersWithHttpInfo(
    richMenuBulkUnlinkRequest: RichMenuBulkUnlinkRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = richMenuBulkUnlinkRequest;

    const res = await this.httpClient.post(
      "/v2/bot/richmenu/bulk/unlink",
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Update rich menu alias
   * @param richMenuAliasId The rich menu alias ID you want to update.
   * @param updateRichMenuAliasRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#update-rich-menu-alias"> Documentation</a>
   */
  public async updateRichMenuAlias(
    richMenuAliasId: string,
    updateRichMenuAliasRequest: UpdateRichMenuAliasRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (
      await this.updateRichMenuAliasWithHttpInfo(
        richMenuAliasId,
        updateRichMenuAliasRequest,
      )
    ).body;
  }

  /**
   * Update rich menu alias.
   * This method includes HttpInfo object to return additional information.
   * @param richMenuAliasId The rich menu alias ID you want to update.
   * @param updateRichMenuAliasRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#update-rich-menu-alias"> Documentation</a>
   */
  public async updateRichMenuAliasWithHttpInfo(
    richMenuAliasId: string,
    updateRichMenuAliasRequest: UpdateRichMenuAliasRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = updateRichMenuAliasRequest;

    const res = await this.httpClient.post(
      "/v2/bot/richmenu/alias/{richMenuAliasId}".replace(
        "{richMenuAliasId}",
        String(richMenuAliasId),
      ),
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Validate message objects of a broadcast message
   * @param validateMessageRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-broadcast-message"> Documentation</a>
   */
  public async validateBroadcast(
    validateMessageRequest: ValidateMessageRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.validateBroadcastWithHttpInfo(validateMessageRequest))
      .body;
  }

  /**
   * Validate message objects of a broadcast message.
   * This method includes HttpInfo object to return additional information.
   * @param validateMessageRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-broadcast-message"> Documentation</a>
   */
  public async validateBroadcastWithHttpInfo(
    validateMessageRequest: ValidateMessageRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = validateMessageRequest;

    const res = await this.httpClient.post(
      "/v2/bot/message/validate/broadcast",
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Validate message objects of a multicast message
   * @param validateMessageRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-multicast-message"> Documentation</a>
   */
  public async validateMulticast(
    validateMessageRequest: ValidateMessageRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.validateMulticastWithHttpInfo(validateMessageRequest))
      .body;
  }

  /**
   * Validate message objects of a multicast message.
   * This method includes HttpInfo object to return additional information.
   * @param validateMessageRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-multicast-message"> Documentation</a>
   */
  public async validateMulticastWithHttpInfo(
    validateMessageRequest: ValidateMessageRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = validateMessageRequest;

    const res = await this.httpClient.post(
      "/v2/bot/message/validate/multicast",
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Validate message objects of a narrowcast message
   * @param validateMessageRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-narrowcast-message"> Documentation</a>
   */
  public async validateNarrowcast(
    validateMessageRequest: ValidateMessageRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.validateNarrowcastWithHttpInfo(validateMessageRequest))
      .body;
  }

  /**
   * Validate message objects of a narrowcast message.
   * This method includes HttpInfo object to return additional information.
   * @param validateMessageRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-narrowcast-message"> Documentation</a>
   */
  public async validateNarrowcastWithHttpInfo(
    validateMessageRequest: ValidateMessageRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = validateMessageRequest;

    const res = await this.httpClient.post(
      "/v2/bot/message/validate/narrowcast",
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Validate message objects of a push message
   * @param validateMessageRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-push-message"> Documentation</a>
   */
  public async validatePush(
    validateMessageRequest: ValidateMessageRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.validatePushWithHttpInfo(validateMessageRequest)).body;
  }

  /**
   * Validate message objects of a push message.
   * This method includes HttpInfo object to return additional information.
   * @param validateMessageRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-push-message"> Documentation</a>
   */
  public async validatePushWithHttpInfo(
    validateMessageRequest: ValidateMessageRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = validateMessageRequest;

    const res = await this.httpClient.post(
      "/v2/bot/message/validate/push",
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Validate message objects of a reply message
   * @param validateMessageRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-reply-message"> Documentation</a>
   */
  public async validateReply(
    validateMessageRequest: ValidateMessageRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.validateReplyWithHttpInfo(validateMessageRequest)).body;
  }

  /**
   * Validate message objects of a reply message.
   * This method includes HttpInfo object to return additional information.
   * @param validateMessageRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-reply-message"> Documentation</a>
   */
  public async validateReplyWithHttpInfo(
    validateMessageRequest: ValidateMessageRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = validateMessageRequest;

    const res = await this.httpClient.post(
      "/v2/bot/message/validate/reply",
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Validate a request body of the Replace or unlink the linked rich menus in batches endpoint.
   * @param richMenuBatchRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-batch-control-rich-menus-request"> Documentation</a>
   */
  public async validateRichMenuBatchRequest(
    richMenuBatchRequest: RichMenuBatchRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (
      await this.validateRichMenuBatchRequestWithHttpInfo(richMenuBatchRequest)
    ).body;
  }

  /**
   * Validate a request body of the Replace or unlink the linked rich menus in batches endpoint..
   * This method includes HttpInfo object to return additional information.
   * @param richMenuBatchRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-batch-control-rich-menus-request"> Documentation</a>
   */
  public async validateRichMenuBatchRequestWithHttpInfo(
    richMenuBatchRequest: RichMenuBatchRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = richMenuBatchRequest;

    const res = await this.httpClient.post(
      "/v2/bot/richmenu/validate/batch",
      params,
    );
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
  /**
   * Validate rich menu object
   * @param richMenuRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-rich-menu-object"> Documentation</a>
   */
  public async validateRichMenuObject(
    richMenuRequest: RichMenuRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.validateRichMenuObjectWithHttpInfo(richMenuRequest))
      .body;
  }

  /**
   * Validate rich menu object.
   * This method includes HttpInfo object to return additional information.
   * @param richMenuRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-rich-menu-object"> Documentation</a>
   */
  public async validateRichMenuObjectWithHttpInfo(
    richMenuRequest: RichMenuRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = richMenuRequest;

    const res = await this.httpClient.post("/v2/bot/richmenu/validate", params);
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
}
