/**
 * Mission Stickers API
 * This document describes LINE Mission Stickers API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/* tslint:disable:no-unused-locals */
import { MissionStickerRequest } from "../model/missionStickerRequest.js";

import * as Types from "../../types.js";
import { ensureJSON } from "../../utils.js";
import { Readable } from "node:stream";

import HTTPFetchClient, {
  convertResponseToReadable,
  mergeHeaders,
} from "../../http-fetch.js";

// ===============================================
// This file is autogenerated - Please do not edit
// ===============================================

interface httpClientConfig {
  baseURL?: string;
  channelAccessToken: string;
  defaultHeaders?: Record<string, string>;
}

export class ShopClient {
  private httpClient: HTTPFetchClient;

  constructor(config: httpClientConfig) {
    const baseURL = config.baseURL || "https://api.line.me";
    const defaultHeaders = mergeHeaders(config.defaultHeaders, {
      Authorization: "Bearer " + config.channelAccessToken,
    });
    this.httpClient = new HTTPFetchClient({
      defaultHeaders: defaultHeaders,
      baseURL: baseURL,
    });
  }

  /**
   * Sends a mission sticker.
   * @param missionStickerRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/partner-docs/#send-mission-stickers-v3"> Documentation</a>
   */
  public async missionStickerV3(
    missionStickerRequest: MissionStickerRequest,
  ): Promise<Types.MessageAPIResponseBase> {
    return (await this.missionStickerV3WithHttpInfo(missionStickerRequest))
      .body;
  }

  /**
   * Sends a mission sticker..
   * This method includes HttpInfo object to return additional information.
   * @param missionStickerRequest
   *
   * @see <a href="https://developers.line.biz/en/reference/partner-docs/#send-mission-stickers-v3"> Documentation</a>
   */
  public async missionStickerV3WithHttpInfo(
    missionStickerRequest: MissionStickerRequest,
  ): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>> {
    const params = missionStickerRequest;

    const res = await this.httpClient.post("/shop/v3/mission", params);
    const text = await res.text();
    const parsedBody = text ? JSON.parse(text) : null;
    return { httpResponse: res, body: parsedBody };
  }
}
