// This file is auto-generated by @hey-api/openapi-ts
import { z } from "zod/v4";
/**
 * Describes an available authentication method.
 */
export const zAuthMethod = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    description: z.union([z.string(), z.null()]).optional(),
    id: z.string(),
    name: z.string(),
});
/**
 * Request parameters for the authenticate method.
 *
 * Specifies which authentication method to use.
 */
export const zAuthenticateRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    methodId: z.string(),
});
/**
 * Response to the `authenticate` method.
 */
export const zAuthenticateResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
});
/**
 * Binary resource contents.
 */
export const zBlobResourceContents = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    blob: z.string(),
    mimeType: z.union([z.string(), z.null()]).optional(),
    uri: z.string(),
});
/**
 * Response containing the ID of the created terminal.
 */
export const zCreateTerminalResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    terminalId: z.string(),
});
/**
 * A diff representing file modifications.
 *
 * Shows changes to files in a format suitable for display in the client UI.
 *
 * See protocol docs: [Content](https://agentclientprotocol.com/protocol/tool-calls#content)
 */
export const zDiff = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    newText: z.string(),
    oldText: z.union([z.string(), z.null()]).optional(),
    path: z.string(),
});
/**
 * An environment variable to set when launching an MCP server.
 */
export const zEnvVariable = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    name: z.string(),
    value: z.string(),
});
/**
 * Predefined error codes for common JSON-RPC and ACP-specific errors.
 *
 * These codes follow the JSON-RPC 2.0 specification for standard errors
 * and use the reserved range (-32000 to -32099) for protocol-specific errors.
 */
export const zErrorCode = z.union([
    z.literal(-32700),
    z.literal(-32600),
    z.literal(-32601),
    z.literal(-32602),
    z.literal(-32603),
    z.literal(-32800),
    z.literal(-32000),
    z.literal(-32002),
    z
        .number()
        .int()
        .min(-2147483648, {
        message: "Invalid value: Expected int32 to be >= -2147483648",
    })
        .max(2147483647, {
        message: "Invalid value: Expected int32 to be <= 2147483647",
    }),
]);
/**
 * JSON-RPC error object.
 *
 * Represents an error that occurred during method execution, following the
 * JSON-RPC 2.0 error object specification with optional additional data.
 *
 * See protocol docs: [JSON-RPC Error Object](https://www.jsonrpc.org/specification#error_object)
 */
export const zError = z.object({
    code: zErrorCode,
    data: z.unknown().optional(),
    message: z.string(),
});
/**
 * Allows the Agent to send an arbitrary notification that is not part of the ACP spec.
 * Extension notifications provide a way to send one-way messages for custom functionality
 * while maintaining protocol compatibility.
 *
 * See protocol docs: [Extensibility](https://agentclientprotocol.com/protocol/extensibility)
 */
export const zExtNotification = z.unknown();
/**
 * Allows for sending an arbitrary request that is not part of the ACP spec.
 * Extension methods provide a way to add custom functionality while maintaining
 * protocol compatibility.
 *
 * See protocol docs: [Extensibility](https://agentclientprotocol.com/protocol/extensibility)
 */
export const zExtRequest = z.unknown();
/**
 * Allows for sending an arbitrary response to an [`ExtRequest`] that is not part of the ACP spec.
 * Extension methods provide a way to add custom functionality while maintaining
 * protocol compatibility.
 *
 * See protocol docs: [Extensibility](https://agentclientprotocol.com/protocol/extensibility)
 */
export const zExtResponse = z.unknown();
/**
 * Filesystem capabilities supported by the client.
 * File system capabilities that a client may support.
 *
 * See protocol docs: [FileSystem](https://agentclientprotocol.com/protocol/initialization#filesystem)
 */
export const zFileSystemCapability = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    readTextFile: z.boolean().optional().default(false),
    writeTextFile: z.boolean().optional().default(false),
});
/**
 * Capabilities supported by the client.
 *
 * Advertised during initialization to inform the agent about
 * available features and methods.
 *
 * See protocol docs: [Client Capabilities](https://agentclientprotocol.com/protocol/initialization#client-capabilities)
 */
export const zClientCapabilities = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    fs: zFileSystemCapability
        .optional()
        .default({ readTextFile: false, writeTextFile: false }),
    terminal: z.boolean().optional().default(false),
});
/**
 * An HTTP header to set when making requests to the MCP server.
 */
export const zHttpHeader = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    name: z.string(),
    value: z.string(),
});
/**
 * Metadata about the implementation of the client or agent.
 * Describes the name and version of an MCP implementation, with an optional
 * title for UI representation.
 */
export const zImplementation = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    name: z.string(),
    title: z.union([z.string(), z.null()]).optional(),
    version: z.string(),
});
/**
 * Response to terminal/kill command method
 */
export const zKillTerminalCommandResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Request parameters for listing existing sessions.
 *
 * Only available if the Agent supports the `listSessions` capability.
 *
 * @experimental
 */
export const zListSessionsRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    cursor: z.union([z.string(), z.null()]).optional(),
    cwd: z.union([z.string(), z.null()]).optional(),
});
/**
 * MCP capabilities supported by the agent
 */
export const zMcpCapabilities = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    http: z.boolean().optional().default(false),
    sse: z.boolean().optional().default(false),
});
/**
 * HTTP transport configuration for MCP.
 */
export const zMcpServerHttp = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    headers: z.array(zHttpHeader),
    name: z.string(),
    url: z.string(),
});
/**
 * SSE transport configuration for MCP.
 */
export const zMcpServerSse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    headers: z.array(zHttpHeader),
    name: z.string(),
    url: z.string(),
});
/**
 * Stdio transport configuration for MCP.
 */
export const zMcpServerStdio = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    args: z.array(z.string()),
    command: z.string(),
    env: z.array(zEnvVariable),
    name: z.string(),
});
/**
 * Configuration for connecting to an MCP (Model Context Protocol) server.
 *
 * MCP servers provide tools and context that the agent can use when
 * processing prompts.
 *
 * See protocol docs: [MCP Servers](https://agentclientprotocol.com/protocol/session-setup#mcp-servers)
 */
export const zMcpServer = z.union([
    zMcpServerHttp.and(z.object({
        type: z.literal("http"),
    })),
    zMcpServerSse.and(z.object({
        type: z.literal("sse"),
    })),
    zMcpServerStdio,
]);
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * A unique identifier for a model.
 *
 * @experimental
 */
export const zModelId = z.string();
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Information about a selectable model.
 *
 * @experimental
 */
export const zModelInfo = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    description: z.union([z.string(), z.null()]).optional(),
    modelId: zModelId,
    name: z.string(),
});
/**
 * Request parameters for creating a new session.
 *
 * See protocol docs: [Creating a Session](https://agentclientprotocol.com/protocol/session-setup#creating-a-session)
 */
export const zNewSessionRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    cwd: z.string(),
    mcpServers: z.array(zMcpServer),
});
/**
 * Unique identifier for a permission option.
 */
export const zPermissionOptionId = z.string();
/**
 * The type of permission option being presented to the user.
 *
 * Helps clients choose appropriate icons and UI treatment.
 */
export const zPermissionOptionKind = z.union([
    z.literal("allow_once"),
    z.literal("allow_always"),
    z.literal("reject_once"),
    z.literal("reject_always"),
]);
/**
 * An option presented to the user when requesting permission.
 */
export const zPermissionOption = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    kind: zPermissionOptionKind,
    name: z.string(),
    optionId: zPermissionOptionId,
});
/**
 * Priority levels for plan entries.
 *
 * Used to indicate the relative importance or urgency of different
 * tasks in the execution plan.
 * See protocol docs: [Plan Entries](https://agentclientprotocol.com/protocol/agent-plan#plan-entries)
 */
export const zPlanEntryPriority = z.union([
    z.literal("high"),
    z.literal("medium"),
    z.literal("low"),
]);
/**
 * Status of a plan entry in the execution flow.
 *
 * Tracks the lifecycle of each task from planning through completion.
 * See protocol docs: [Plan Entries](https://agentclientprotocol.com/protocol/agent-plan#plan-entries)
 */
export const zPlanEntryStatus = z.union([
    z.literal("pending"),
    z.literal("in_progress"),
    z.literal("completed"),
]);
/**
 * A single entry in the execution plan.
 *
 * Represents a task or goal that the assistant intends to accomplish
 * as part of fulfilling the user's request.
 * See protocol docs: [Plan Entries](https://agentclientprotocol.com/protocol/agent-plan#plan-entries)
 */
export const zPlanEntry = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    content: z.string(),
    priority: zPlanEntryPriority,
    status: zPlanEntryStatus,
});
/**
 * An execution plan for accomplishing complex tasks.
 *
 * Plans consist of multiple entries representing individual tasks or goals.
 * Agents report plans to clients to provide visibility into their execution strategy.
 * Plans can evolve during execution as the agent discovers new requirements or completes tasks.
 *
 * See protocol docs: [Agent Plan](https://agentclientprotocol.com/protocol/agent-plan)
 */
export const zPlan = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    entries: z.array(zPlanEntry),
});
/**
 * Prompt capabilities supported by the agent in `session/prompt` requests.
 *
 * Baseline agent functionality requires support for [`ContentBlock::Text`]
 * and [`ContentBlock::ResourceLink`] in prompt requests.
 *
 * Other variants must be explicitly opted in to.
 * Capabilities for different types of content in prompt requests.
 *
 * Indicates which content types beyond the baseline (text and resource links)
 * the agent can process.
 *
 * See protocol docs: [Prompt Capabilities](https://agentclientprotocol.com/protocol/initialization#prompt-capabilities)
 */
export const zPromptCapabilities = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    audio: z.boolean().optional().default(false),
    embeddedContext: z.boolean().optional().default(false),
    image: z.boolean().optional().default(false),
});
/**
 * Protocol version identifier.
 *
 * This version is only bumped for breaking changes.
 * Non-breaking changes should be introduced via capabilities.
 */
export const zProtocolVersion = z.number().int().gte(0).lte(65535);
/**
 * Request parameters for the initialize method.
 *
 * Sent by the client to establish connection and negotiate capabilities.
 *
 * See protocol docs: [Initialization](https://agentclientprotocol.com/protocol/initialization)
 */
export const zInitializeRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    clientCapabilities: zClientCapabilities.optional().default({
        fs: { readTextFile: false, writeTextFile: false },
        terminal: false,
    }),
    clientInfo: z.union([zImplementation, z.null()]).optional(),
    protocolVersion: zProtocolVersion,
});
/**
 * Response containing the contents of a text file.
 */
export const zReadTextFileResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    content: z.string(),
});
/**
 * Response to terminal/release method
 */
export const zReleaseTerminalResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
});
/**
 * JSON RPC Request Id
 *
 * An identifier established by the Client that MUST contain a String, Number, or NULL value if included. If it is not included it is assumed to be a notification. The value SHOULD normally not be Null [1] and Numbers SHOULD NOT contain fractional parts [2]
 *
 * The Server MUST reply with the same value in the Response object if included. This member is used to correlate the context between the two objects.
 *
 * [1] The use of Null as a value for the id member in a Request object is discouraged, because this specification uses a value of Null for Responses with an unknown id. Also, because JSON-RPC 1.0 uses an id value of Null for Notifications this could cause confusion in handling.
 *
 * [2] Fractional parts may be problematic, since many decimal fractions cannot be represented exactly as binary fractions.
 */
export const zRequestId = z.union([
    z.null(),
    z.coerce
        .bigint()
        .min(BigInt("-9223372036854775808"), {
        message: "Invalid value: Expected int64 to be >= -9223372036854775808",
    })
        .max(BigInt("9223372036854775807"), {
        message: "Invalid value: Expected int64 to be <= 9223372036854775807",
    }),
    z.string(),
]);
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Notification to cancel an ongoing request.
 *
 * See protocol docs: [Cancellation](https://agentclientprotocol.com/protocol/cancellation)
 *
 * @experimental
 */
export const zCancelRequestNotification = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    requestId: zRequestId,
});
/**
 * The sender or recipient of messages and data in a conversation.
 */
export const zRole = z.enum(["assistant", "user"]);
/**
 * Optional annotations for the client. The client can use annotations to inform how objects are used or displayed
 */
export const zAnnotations = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    audience: z.union([z.array(zRole), z.null()]).optional(),
    lastModified: z.union([z.string(), z.null()]).optional(),
    priority: z.union([z.number(), z.null()]).optional(),
});
/**
 * Audio provided to or from an LLM.
 */
export const zAudioContent = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    annotations: z.union([zAnnotations, z.null()]).optional(),
    data: z.string(),
    mimeType: z.string(),
});
/**
 * An image provided to or from an LLM.
 */
export const zImageContent = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    annotations: z.union([zAnnotations, z.null()]).optional(),
    data: z.string(),
    mimeType: z.string(),
    uri: z.union([z.string(), z.null()]).optional(),
});
/**
 * A resource that the server is capable of reading, included in a prompt or tool call result.
 */
export const zResourceLink = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    annotations: z.union([zAnnotations, z.null()]).optional(),
    description: z.union([z.string(), z.null()]).optional(),
    mimeType: z.union([z.string(), z.null()]).optional(),
    name: z.string(),
    size: z
        .union([
        z.coerce
            .bigint()
            .min(BigInt("-9223372036854775808"), {
            message: "Invalid value: Expected int64 to be >= -9223372036854775808",
        })
            .max(BigInt("9223372036854775807"), {
            message: "Invalid value: Expected int64 to be <= 9223372036854775807",
        }),
        z.null(),
    ])
        .optional(),
    title: z.union([z.string(), z.null()]).optional(),
    uri: z.string(),
});
/**
 * The user selected one of the provided options.
 */
export const zSelectedPermissionOutcome = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    optionId: zPermissionOptionId,
});
/**
 * The outcome of a permission request.
 */
export const zRequestPermissionOutcome = z.union([
    z.object({
        outcome: z.literal("cancelled"),
    }),
    zSelectedPermissionOutcome.and(z.object({
        outcome: z.literal("selected"),
    })),
]);
/**
 * Response to a permission request.
 */
export const zRequestPermissionResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    outcome: zRequestPermissionOutcome,
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Unique identifier for a session configuration option value group.
 *
 * @experimental
 */
export const zSessionConfigGroupId = z.string();
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Unique identifier for a session configuration option.
 *
 * @experimental
 */
export const zSessionConfigId = z.string();
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Semantic category for a session configuration option.
 *
 * This is intended to help Clients distinguish broadly common selectors (e.g. model selector vs
 * session mode selector vs thought/reasoning level) for UX purposes (keyboard shortcuts, icons,
 * placement). It MUST NOT be required for correctness. Clients MUST handle missing or unknown
 * categories gracefully.
 *
 * Category names beginning with `_` are free for custom use, like other ACP extension methods.
 * Category names that do not begin with `_` are reserved for the ACP spec.
 *
 * @experimental
 */
export const zSessionConfigOptionCategory = z.union([
    z.literal("mode"),
    z.literal("model"),
    z.literal("thought_level"),
    z.string(),
]);
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Unique identifier for a session configuration option value.
 *
 * @experimental
 */
export const zSessionConfigValueId = z.string();
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * A possible value for a session configuration option.
 *
 * @experimental
 */
export const zSessionConfigSelectOption = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    description: z.union([z.string(), z.null()]).optional(),
    name: z.string(),
    value: zSessionConfigValueId,
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * A group of possible values for a session configuration option.
 *
 * @experimental
 */
export const zSessionConfigSelectGroup = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    group: zSessionConfigGroupId,
    name: z.string(),
    options: z.array(zSessionConfigSelectOption),
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Possible values for a session configuration option.
 *
 * @experimental
 */
export const zSessionConfigSelectOptions = z.union([
    z.array(zSessionConfigSelectOption),
    z.array(zSessionConfigSelectGroup),
]);
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * A single-value selector (dropdown) session configuration option payload.
 *
 * @experimental
 */
export const zSessionConfigSelect = z.object({
    currentValue: zSessionConfigValueId,
    options: zSessionConfigSelectOptions,
});
export const zSessionConfigOption = zSessionConfigSelect
    .and(z.object({
    type: z.literal("select"),
}))
    .and(z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    category: z.union([zSessionConfigOptionCategory, z.null()]).optional(),
    description: z.union([z.string(), z.null()]).optional(),
    id: zSessionConfigId,
    name: z.string(),
}));
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Session configuration options have been updated.
 *
 * @experimental
 */
export const zConfigOptionUpdate = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    configOptions: z.array(zSessionConfigOption),
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Capabilities for the `session/fork` method.
 *
 * By supplying `{}` it means that the agent supports forking of sessions.
 *
 * @experimental
 */
export const zSessionForkCapabilities = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
});
/**
 * A unique identifier for a conversation session between a client and agent.
 *
 * Sessions maintain their own context, conversation history, and state,
 * allowing multiple independent interactions with the same agent.
 *
 * See protocol docs: [Session ID](https://agentclientprotocol.com/protocol/session-setup#session-id)
 */
export const zSessionId = z.string();
/**
 * Notification to cancel ongoing operations for a session.
 *
 * See protocol docs: [Cancellation](https://agentclientprotocol.com/protocol/prompt-turn#cancellation)
 */
export const zCancelNotification = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    sessionId: zSessionId,
});
export const zClientNotification = z.object({
    method: z.string(),
    params: z
        .union([z.union([zCancelNotification, zExtNotification]), z.null()])
        .optional(),
});
/**
 * Request to create a new terminal and execute a command.
 */
export const zCreateTerminalRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    args: z.array(z.string()).optional(),
    command: z.string(),
    cwd: z.union([z.string(), z.null()]).optional(),
    env: z.array(zEnvVariable).optional(),
    outputByteLimit: z
        .union([
        z.coerce.bigint().gte(BigInt(0)).max(BigInt("18446744073709551615"), {
            message: "Invalid value: Expected uint64 to be <= 18446744073709551615",
        }),
        z.null(),
    ])
        .optional(),
    sessionId: zSessionId,
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Request parameters for forking an existing session.
 *
 * Creates a new session based on the context of an existing one, allowing
 * operations like generating summaries without affecting the original session's history.
 *
 * Only available if the Agent supports the `session.fork` capability.
 *
 * @experimental
 */
export const zForkSessionRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    cwd: z.string(),
    mcpServers: z.array(zMcpServer).optional(),
    sessionId: zSessionId,
});
/**
 * Request to kill a terminal command without releasing the terminal.
 */
export const zKillTerminalCommandRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    sessionId: zSessionId,
    terminalId: z.string(),
});
/**
 * Request parameters for loading an existing session.
 *
 * Only available if the Agent supports the `loadSession` capability.
 *
 * See protocol docs: [Loading Sessions](https://agentclientprotocol.com/protocol/session-setup#loading-sessions)
 */
export const zLoadSessionRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    cwd: z.string(),
    mcpServers: z.array(zMcpServer),
    sessionId: zSessionId,
});
/**
 * Request to read content from a text file.
 *
 * Only available if the client supports the `fs.readTextFile` capability.
 */
export const zReadTextFileRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    limit: z
        .union([
        z.number().int().gte(0).max(4294967295, {
            message: "Invalid value: Expected uint32 to be <= 4294967295",
        }),
        z.null(),
    ])
        .optional(),
    line: z
        .union([
        z.number().int().gte(0).max(4294967295, {
            message: "Invalid value: Expected uint32 to be <= 4294967295",
        }),
        z.null(),
    ])
        .optional(),
    path: z.string(),
    sessionId: zSessionId,
});
/**
 * Request to release a terminal and free its resources.
 */
export const zReleaseTerminalRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    sessionId: zSessionId,
    terminalId: z.string(),
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Request parameters for resuming an existing session.
 *
 * Resumes an existing session without returning previous messages (unlike `session/load`).
 * This is useful for agents that can resume sessions but don't implement full session loading.
 *
 * Only available if the Agent supports the `session.resume` capability.
 *
 * @experimental
 */
export const zResumeSessionRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    cwd: z.string(),
    mcpServers: z.array(zMcpServer).optional(),
    sessionId: zSessionId,
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Information about a session returned by session/list
 *
 * @experimental
 */
export const zSessionInfo = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    cwd: z.string(),
    sessionId: zSessionId,
    title: z.union([z.string(), z.null()]).optional(),
    updatedAt: z.union([z.string(), z.null()]).optional(),
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Response from listing sessions.
 *
 * @experimental
 */
export const zListSessionsResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    nextCursor: z.union([z.string(), z.null()]).optional(),
    sessions: z.array(zSessionInfo),
});
/**
 * Update to session metadata. All fields are optional to support partial updates.
 *
 * Agents send this notification to update session information like title or custom metadata.
 * This allows clients to display dynamic session names and track session state changes.
 */
export const zSessionInfoUpdate = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    title: z.union([z.string(), z.null()]).optional(),
    updatedAt: z.union([z.string(), z.null()]).optional(),
});
/**
 * Capabilities for the `session/list` method.
 *
 * By supplying `{}` it means that the agent supports listing of sessions.
 *
 * Further capabilities can be added in the future for other means of filtering or searching the list.
 */
export const zSessionListCapabilities = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
});
/**
 * Unique identifier for a Session Mode.
 */
export const zSessionModeId = z.string();
/**
 * The current mode of the session has changed
 *
 * See protocol docs: [Session Modes](https://agentclientprotocol.com/protocol/session-modes)
 */
export const zCurrentModeUpdate = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    currentModeId: zSessionModeId,
});
/**
 * A mode the agent can operate in.
 *
 * See protocol docs: [Session Modes](https://agentclientprotocol.com/protocol/session-modes)
 */
export const zSessionMode = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    description: z.union([z.string(), z.null()]).optional(),
    id: zSessionModeId,
    name: z.string(),
});
/**
 * The set of modes and the one currently active.
 */
export const zSessionModeState = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    availableModes: z.array(zSessionMode),
    currentModeId: zSessionModeId,
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * The set of models and the one currently active.
 *
 * @experimental
 */
export const zSessionModelState = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    availableModels: z.array(zModelInfo),
    currentModelId: zModelId,
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Response from forking an existing session.
 *
 * @experimental
 */
export const zForkSessionResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    configOptions: z.union([z.array(zSessionConfigOption), z.null()]).optional(),
    models: z.union([zSessionModelState, z.null()]).optional(),
    modes: z.union([zSessionModeState, z.null()]).optional(),
    sessionId: zSessionId,
});
/**
 * Response from loading an existing session.
 */
export const zLoadSessionResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    configOptions: z.union([z.array(zSessionConfigOption), z.null()]).optional(),
    models: z.union([zSessionModelState, z.null()]).optional(),
    modes: z.union([zSessionModeState, z.null()]).optional(),
});
/**
 * Response from creating a new session.
 *
 * See protocol docs: [Creating a Session](https://agentclientprotocol.com/protocol/session-setup#creating-a-session)
 */
export const zNewSessionResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    configOptions: z.union([z.array(zSessionConfigOption), z.null()]).optional(),
    models: z.union([zSessionModelState, z.null()]).optional(),
    modes: z.union([zSessionModeState, z.null()]).optional(),
    sessionId: zSessionId,
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Response from resuming an existing session.
 *
 * @experimental
 */
export const zResumeSessionResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    configOptions: z.union([z.array(zSessionConfigOption), z.null()]).optional(),
    models: z.union([zSessionModelState, z.null()]).optional(),
    modes: z.union([zSessionModeState, z.null()]).optional(),
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Capabilities for the `session/resume` method.
 *
 * By supplying `{}` it means that the agent supports resuming of sessions.
 *
 * @experimental
 */
export const zSessionResumeCapabilities = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
});
/**
 * Session capabilities supported by the agent.
 *
 * As a baseline, all Agents **MUST** support `session/new`, `session/prompt`, `session/cancel`, and `session/update`.
 *
 * Optionally, they **MAY** support other session methods and notifications by specifying additional capabilities.
 *
 * Note: `session/load` is still handled by the top-level `load_session` capability. This will be unified in future versions of the protocol.
 *
 * See protocol docs: [Session Capabilities](https://agentclientprotocol.com/protocol/initialization#session-capabilities)
 */
export const zSessionCapabilities = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    fork: z.union([zSessionForkCapabilities, z.null()]).optional(),
    list: z.union([zSessionListCapabilities, z.null()]).optional(),
    resume: z.union([zSessionResumeCapabilities, z.null()]).optional(),
});
/**
 * Capabilities supported by the agent.
 *
 * Advertised during initialization to inform the client about
 * available features and content types.
 *
 * See protocol docs: [Agent Capabilities](https://agentclientprotocol.com/protocol/initialization#agent-capabilities)
 */
export const zAgentCapabilities = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    loadSession: z.boolean().optional().default(false),
    mcpCapabilities: zMcpCapabilities
        .optional()
        .default({ http: false, sse: false }),
    promptCapabilities: zPromptCapabilities.optional().default({
        audio: false,
        embeddedContext: false,
        image: false,
    }),
    sessionCapabilities: zSessionCapabilities.optional().default({}),
});
/**
 * Response to the `initialize` method.
 *
 * Contains the negotiated protocol version and agent capabilities.
 *
 * See protocol docs: [Initialization](https://agentclientprotocol.com/protocol/initialization)
 */
export const zInitializeResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    agentCapabilities: zAgentCapabilities.optional().default({
        loadSession: false,
        mcpCapabilities: { http: false, sse: false },
        promptCapabilities: {
            audio: false,
            embeddedContext: false,
            image: false,
        },
        sessionCapabilities: {},
    }),
    agentInfo: z.union([zImplementation, z.null()]).optional(),
    authMethods: z.array(zAuthMethod).optional().default([]),
    protocolVersion: zProtocolVersion,
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Request parameters for setting a session configuration option.
 *
 * @experimental
 */
export const zSetSessionConfigOptionRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    configId: zSessionConfigId,
    sessionId: zSessionId,
    value: zSessionConfigValueId,
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Response to `session/set_config_option` method.
 *
 * @experimental
 */
export const zSetSessionConfigOptionResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    configOptions: z.array(zSessionConfigOption),
});
/**
 * Request parameters for setting a session mode.
 */
export const zSetSessionModeRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    modeId: zSessionModeId,
    sessionId: zSessionId,
});
/**
 * Response to `session/set_mode` method.
 */
export const zSetSessionModeResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Request parameters for setting a session model.
 *
 * @experimental
 */
export const zSetSessionModelRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    modelId: zModelId,
    sessionId: zSessionId,
});
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Response to `session/set_model` method.
 *
 * @experimental
 */
export const zSetSessionModelResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
});
/**
 * Reasons why an agent stops processing a prompt turn.
 *
 * See protocol docs: [Stop Reasons](https://agentclientprotocol.com/protocol/prompt-turn#stop-reasons)
 */
export const zStopReason = z.union([
    z.literal("end_turn"),
    z.literal("max_tokens"),
    z.literal("max_turn_requests"),
    z.literal("refusal"),
    z.literal("cancelled"),
]);
/**
 * Response from processing a user prompt.
 *
 * See protocol docs: [Check for Completion](https://agentclientprotocol.com/protocol/prompt-turn#4-check-for-completion)
 */
export const zPromptResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    stopReason: zStopReason,
});
export const zAgentResponse = z.union([
    z.object({
        id: zRequestId,
        result: z.union([
            zInitializeResponse,
            zAuthenticateResponse,
            zNewSessionResponse,
            zLoadSessionResponse,
            zListSessionsResponse,
            zForkSessionResponse,
            zResumeSessionResponse,
            zSetSessionModeResponse,
            zSetSessionConfigOptionResponse,
            zPromptResponse,
            zSetSessionModelResponse,
            zExtResponse,
        ]),
    }),
    z.object({
        error: zError,
        id: zRequestId,
    }),
]);
/**
 * Embed a terminal created with `terminal/create` by its id.
 *
 * The terminal must be added before calling `terminal/release`.
 *
 * See protocol docs: [Terminal](https://agentclientprotocol.com/protocol/terminals)
 */
export const zTerminal = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    terminalId: z.string(),
});
/**
 * Exit status of a terminal command.
 */
export const zTerminalExitStatus = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    exitCode: z
        .union([
        z.number().int().gte(0).max(4294967295, {
            message: "Invalid value: Expected uint32 to be <= 4294967295",
        }),
        z.null(),
    ])
        .optional(),
    signal: z.union([z.string(), z.null()]).optional(),
});
/**
 * Request to get the current output and status of a terminal.
 */
export const zTerminalOutputRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    sessionId: zSessionId,
    terminalId: z.string(),
});
/**
 * Response containing the terminal output and exit status.
 */
export const zTerminalOutputResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    exitStatus: z.union([zTerminalExitStatus, z.null()]).optional(),
    output: z.string(),
    truncated: z.boolean(),
});
/**
 * Text provided to or from an LLM.
 */
export const zTextContent = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    annotations: z.union([zAnnotations, z.null()]).optional(),
    text: z.string(),
});
/**
 * Text-based resource contents.
 */
export const zTextResourceContents = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    mimeType: z.union([z.string(), z.null()]).optional(),
    text: z.string(),
    uri: z.string(),
});
/**
 * Resource content that can be embedded in a message.
 */
export const zEmbeddedResourceResource = z.union([
    zTextResourceContents,
    zBlobResourceContents,
]);
/**
 * The contents of a resource, embedded into a prompt or tool call result.
 */
export const zEmbeddedResource = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    annotations: z.union([zAnnotations, z.null()]).optional(),
    resource: zEmbeddedResourceResource,
});
/**
 * Content blocks represent displayable information in the Agent Client Protocol.
 *
 * They provide a structured way to handle various types of user-facing content—whether
 * it's text from language models, images for analysis, or embedded resources for context.
 *
 * Content blocks appear in:
 * - User prompts sent via `session/prompt`
 * - Language model output streamed through `session/update` notifications
 * - Progress updates and results from tool calls
 *
 * This structure is compatible with the Model Context Protocol (MCP), enabling
 * agents to seamlessly forward content from MCP tool outputs without transformation.
 *
 * See protocol docs: [Content](https://agentclientprotocol.com/protocol/content)
 */
export const zContentBlock = z.union([
    zTextContent.and(z.object({
        type: z.literal("text"),
    })),
    zImageContent.and(z.object({
        type: z.literal("image"),
    })),
    zAudioContent.and(z.object({
        type: z.literal("audio"),
    })),
    zResourceLink.and(z.object({
        type: z.literal("resource_link"),
    })),
    zEmbeddedResource.and(z.object({
        type: z.literal("resource"),
    })),
]);
/**
 * Standard content block (text, images, resources).
 */
export const zContent = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    content: zContentBlock,
});
/**
 * A streamed item of content
 */
export const zContentChunk = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    content: zContentBlock,
});
/**
 * Request parameters for sending a user prompt to the agent.
 *
 * Contains the user's message and any additional context.
 *
 * See protocol docs: [User Message](https://agentclientprotocol.com/protocol/prompt-turn#1-user-message)
 */
export const zPromptRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    prompt: z.array(zContentBlock),
    sessionId: zSessionId,
});
export const zClientRequest = z.object({
    id: zRequestId,
    method: z.string(),
    params: z
        .union([
        z.union([
            zInitializeRequest,
            zAuthenticateRequest,
            zNewSessionRequest,
            zLoadSessionRequest,
            zListSessionsRequest,
            zForkSessionRequest,
            zResumeSessionRequest,
            zSetSessionModeRequest,
            zSetSessionConfigOptionRequest,
            zPromptRequest,
            zSetSessionModelRequest,
            zExtRequest,
        ]),
        z.null(),
    ])
        .optional(),
});
/**
 * Content produced by a tool call.
 *
 * Tool calls can produce different types of content including
 * standard content blocks (text, images) or file diffs.
 *
 * See protocol docs: [Content](https://agentclientprotocol.com/protocol/tool-calls#content)
 */
export const zToolCallContent = z.union([
    zContent.and(z.object({
        type: z.literal("content"),
    })),
    zDiff.and(z.object({
        type: z.literal("diff"),
    })),
    zTerminal.and(z.object({
        type: z.literal("terminal"),
    })),
]);
/**
 * Unique identifier for a tool call within a session.
 */
export const zToolCallId = z.string();
/**
 * A file location being accessed or modified by a tool.
 *
 * Enables clients to implement "follow-along" features that track
 * which files the agent is working with in real-time.
 *
 * See protocol docs: [Following the Agent](https://agentclientprotocol.com/protocol/tool-calls#following-the-agent)
 */
export const zToolCallLocation = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    line: z
        .union([
        z.number().int().gte(0).max(4294967295, {
            message: "Invalid value: Expected uint32 to be <= 4294967295",
        }),
        z.null(),
    ])
        .optional(),
    path: z.string(),
});
/**
 * Execution status of a tool call.
 *
 * Tool calls progress through different statuses during their lifecycle.
 *
 * See protocol docs: [Status](https://agentclientprotocol.com/protocol/tool-calls#status)
 */
export const zToolCallStatus = z.union([
    z.literal("pending"),
    z.literal("in_progress"),
    z.literal("completed"),
    z.literal("failed"),
]);
/**
 * Categories of tools that can be invoked.
 *
 * Tool kinds help clients choose appropriate icons and optimize how they
 * display tool execution progress.
 *
 * See protocol docs: [Creating](https://agentclientprotocol.com/protocol/tool-calls#creating)
 */
export const zToolKind = z.union([
    z.literal("read"),
    z.literal("edit"),
    z.literal("delete"),
    z.literal("move"),
    z.literal("search"),
    z.literal("execute"),
    z.literal("think"),
    z.literal("fetch"),
    z.literal("switch_mode"),
    z.literal("other"),
]);
/**
 * Represents a tool call that the language model has requested.
 *
 * Tool calls are actions that the agent executes on behalf of the language model,
 * such as reading files, executing code, or fetching data from external sources.
 *
 * See protocol docs: [Tool Calls](https://agentclientprotocol.com/protocol/tool-calls)
 */
export const zToolCall = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    content: z.array(zToolCallContent).optional(),
    kind: zToolKind.optional(),
    locations: z.array(zToolCallLocation).optional(),
    rawInput: z.unknown().optional(),
    rawOutput: z.unknown().optional(),
    status: zToolCallStatus.optional(),
    title: z.string(),
    toolCallId: zToolCallId,
});
/**
 * An update to an existing tool call.
 *
 * Used to report progress and results as tools execute. All fields except
 * the tool call ID are optional - only changed fields need to be included.
 *
 * See protocol docs: [Updating](https://agentclientprotocol.com/protocol/tool-calls#updating)
 */
export const zToolCallUpdate = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    content: z.union([z.array(zToolCallContent), z.null()]).optional(),
    kind: z.union([zToolKind, z.null()]).optional(),
    locations: z.union([z.array(zToolCallLocation), z.null()]).optional(),
    rawInput: z.unknown().optional(),
    rawOutput: z.unknown().optional(),
    status: z.union([zToolCallStatus, z.null()]).optional(),
    title: z.union([z.string(), z.null()]).optional(),
    toolCallId: zToolCallId,
});
/**
 * Request for user permission to execute a tool call.
 *
 * Sent when the agent needs authorization before performing a sensitive operation.
 *
 * See protocol docs: [Requesting Permission](https://agentclientprotocol.com/protocol/tool-calls#requesting-permission)
 */
export const zRequestPermissionRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    options: z.array(zPermissionOption),
    sessionId: zSessionId,
    toolCall: zToolCallUpdate,
});
/**
 * All text that was typed after the command name is provided as input.
 */
export const zUnstructuredCommandInput = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    hint: z.string(),
});
/**
 * unstructured
 *
 * All text that was typed after the command name is provided as input.
 */
export const zAvailableCommandInput = zUnstructuredCommandInput;
/**
 * Information about a command.
 */
export const zAvailableCommand = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    description: z.string(),
    input: z.union([zAvailableCommandInput, z.null()]).optional(),
    name: z.string(),
});
/**
 * Available commands are ready or have changed
 */
export const zAvailableCommandsUpdate = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    availableCommands: z.array(zAvailableCommand),
});
/**
 * Different types of updates that can be sent during session processing.
 *
 * These updates provide real-time feedback about the agent's progress.
 *
 * See protocol docs: [Agent Reports Output](https://agentclientprotocol.com/protocol/prompt-turn#3-agent-reports-output)
 */
export const zSessionUpdate = z.union([
    zContentChunk.and(z.object({
        sessionUpdate: z.literal("user_message_chunk"),
    })),
    zContentChunk.and(z.object({
        sessionUpdate: z.literal("agent_message_chunk"),
    })),
    zContentChunk.and(z.object({
        sessionUpdate: z.literal("agent_thought_chunk"),
    })),
    zToolCall.and(z.object({
        sessionUpdate: z.literal("tool_call"),
    })),
    zToolCallUpdate.and(z.object({
        sessionUpdate: z.literal("tool_call_update"),
    })),
    zPlan.and(z.object({
        sessionUpdate: z.literal("plan"),
    })),
    zAvailableCommandsUpdate.and(z.object({
        sessionUpdate: z.literal("available_commands_update"),
    })),
    zCurrentModeUpdate.and(z.object({
        sessionUpdate: z.literal("current_mode_update"),
    })),
    zConfigOptionUpdate.and(z.object({
        sessionUpdate: z.literal("config_option_update"),
    })),
    zSessionInfoUpdate.and(z.object({
        sessionUpdate: z.literal("session_info_update"),
    })),
]);
/**
 * Notification containing a session update from the agent.
 *
 * Used to stream real-time progress and results during prompt processing.
 *
 * See protocol docs: [Agent Reports Output](https://agentclientprotocol.com/protocol/prompt-turn#3-agent-reports-output)
 */
export const zSessionNotification = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    sessionId: zSessionId,
    update: zSessionUpdate,
});
export const zAgentNotification = z.object({
    method: z.string(),
    params: z
        .union([z.union([zSessionNotification, zExtNotification]), z.null()])
        .optional(),
});
/**
 * Request to wait for a terminal command to exit.
 */
export const zWaitForTerminalExitRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    sessionId: zSessionId,
    terminalId: z.string(),
});
/**
 * Response containing the exit status of a terminal command.
 */
export const zWaitForTerminalExitResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    exitCode: z
        .union([
        z.number().int().gte(0).max(4294967295, {
            message: "Invalid value: Expected uint32 to be <= 4294967295",
        }),
        z.null(),
    ])
        .optional(),
    signal: z.union([z.string(), z.null()]).optional(),
});
/**
 * Request to write content to a text file.
 *
 * Only available if the client supports the `fs.writeTextFile` capability.
 */
export const zWriteTextFileRequest = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
    content: z.string(),
    path: z.string(),
    sessionId: zSessionId,
});
export const zAgentRequest = z.object({
    id: zRequestId,
    method: z.string(),
    params: z
        .union([
        z.union([
            zWriteTextFileRequest,
            zReadTextFileRequest,
            zRequestPermissionRequest,
            zCreateTerminalRequest,
            zTerminalOutputRequest,
            zReleaseTerminalRequest,
            zWaitForTerminalExitRequest,
            zKillTerminalCommandRequest,
            zExtRequest,
        ]),
        z.null(),
    ])
        .optional(),
});
/**
 * Response to `fs/write_text_file`
 */
export const zWriteTextFileResponse = z.object({
    _meta: z.union([z.record(z.string(), z.unknown()), z.null()]).optional(),
});
export const zClientResponse = z.union([
    z.object({
        id: zRequestId,
        result: z.union([
            zWriteTextFileResponse,
            zReadTextFileResponse,
            zRequestPermissionResponse,
            zCreateTerminalResponse,
            zTerminalOutputResponse,
            zReleaseTerminalResponse,
            zWaitForTerminalExitResponse,
            zKillTerminalCommandResponse,
            zExtResponse,
        ]),
    }),
    z.object({
        error: zError,
        id: zRequestId,
    }),
]);
//# sourceMappingURL=zod.gen.js.map