import type { Octokit } from "@octokit/core";
import type { App } from "./index.js";
import type { EachRepositoryFunction, EachRepositoryInterface, EachRepositoryQuery } from "./types.js";
export declare function eachRepositoryFactory(app: App): EachRepositoryInterface<Octokit>;
export declare function eachRepository(app: App, queryOrCallback: EachRepositoryQuery | EachRepositoryFunction<Octokit>, callback?: EachRepositoryFunction<Octokit>): Promise<void>;
export declare function eachRepositoryIterator(app: App, query?: EachRepositoryQuery): {
    [Symbol.asyncIterator](): AsyncGenerator<{
        octokit: Octokit;
        repository: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            license: {
                key: string;
                name: string;
                url: string | null;
                spdx_id: string | null;
                node_id: string;
                html_url?: string;
            } | null;
            forks: number;
            permissions?: {
                admin: boolean;
                pull: boolean;
                triage?: boolean;
                push: boolean;
                maintain?: boolean;
            };
            owner: {
                name?: string | null;
                email?: string | null;
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string | null;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
                starred_at?: string;
                user_view_type?: string;
            };
            private: boolean;
            html_url: string;
            description: string | null;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
            clone_url: string;
            mirror_url: string | null;
            hooks_url: string;
            svn_url: string;
            homepage: string | null;
            language: string | null;
            forks_count: number;
            stargazers_count: number;
            watchers_count: number;
            size: number;
            default_branch: string;
            open_issues_count: number;
            is_template?: boolean;
            topics?: string[];
            has_issues: boolean;
            has_projects: boolean;
            has_wiki: boolean;
            has_pages: boolean;
            has_downloads: boolean;
            has_discussions?: boolean;
            archived: boolean;
            disabled: boolean;
            visibility?: string;
            pushed_at: string | null;
            created_at: string | null;
            updated_at: string | null;
            allow_rebase_merge?: boolean;
            temp_clone_token?: string;
            allow_squash_merge?: boolean;
            allow_auto_merge?: boolean;
            delete_branch_on_merge?: boolean;
            allow_update_branch?: boolean;
            use_squash_pr_title_as_default?: boolean;
            squash_merge_commit_title?: "PR_TITLE" | "COMMIT_OR_PR_TITLE";
            squash_merge_commit_message?: "PR_BODY" | "COMMIT_MESSAGES" | "BLANK";
            merge_commit_title?: "PR_TITLE" | "MERGE_MESSAGE";
            merge_commit_message?: "PR_BODY" | "PR_TITLE" | "BLANK";
            allow_merge_commit?: boolean;
            allow_forking?: boolean;
            web_commit_signoff_required?: boolean;
            open_issues: number;
            watchers: number;
            master_branch?: string;
            starred_at?: string;
            anonymous_access_enabled?: boolean;
            code_search_index_status?: {
                lexical_search_ok?: boolean;
                lexical_commit_sha?: string;
            };
        };
    }, void, unknown>;
};
