"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asConst = void 0;

/**
 * Returns the input parameter without muting it, but narrowing its inferred type. Similar to using the `as const` statement functionnally.
 * @param input Input
 * @returns Input, narrowly typed
 *
 * ```ts
 * const object = { foo: "bar" }
 * // { foo: string }
 *
 * const narrowedObject = asConst({ foo: "bar "})
 * // => { foo: "bar" }
 * ```
 */
var asConst = function asConst(input) {
  return input;
};

exports.asConst = asConst;
//# sourceMappingURL=asConst.js.map